package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.ProjectArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateProjectResponse(projectArn: Option[ProjectArn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.CreateProjectResponse = {
    import CreateProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.CreateProjectResponse
      .builder()
      .optionallyWith(
        projectArn.map(value => ProjectArn.unwrap(value): java.lang.String)
      )(_.projectArn)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.CreateProjectResponse.ReadOnly =
    zio.aws.rekognition.model.CreateProjectResponse.wrap(buildAwsValue())
}
object CreateProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.CreateProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.CreateProjectResponse =
      zio.aws.rekognition.model
        .CreateProjectResponse(projectArn.map(value => value))
    def projectArn: Option[ProjectArn]
    def getProjectArn: ZIO[Any, AwsError, ProjectArn] =
      AwsError.unwrapOptionField("projectArn", projectArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.CreateProjectResponse
  ) extends zio.aws.rekognition.model.CreateProjectResponse.ReadOnly {
    override val projectArn: Option[ProjectArn] = scala
      .Option(impl.projectArn())
      .map(value => zio.aws.rekognition.model.primitives.ProjectArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.CreateProjectResponse
  ): zio.aws.rekognition.model.CreateProjectResponse.ReadOnly = new Wrapper(
    impl
  )
}
