package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{Percent, RekognitionUniqueId, Url}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Celebrity(
    urls: Option[Iterable[Url]] = None,
    name: Option[String] = None,
    id: Option[RekognitionUniqueId] = None,
    face: Option[zio.aws.rekognition.model.ComparedFace] = None,
    matchConfidence: Option[Percent] = None,
    knownGender: Option[zio.aws.rekognition.model.KnownGender] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.Celebrity = {
    import Celebrity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.Celebrity
      .builder()
      .optionallyWith(
        urls.map(value =>
          value.map { item =>
            Url.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.urls)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        id.map(value => RekognitionUniqueId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(face.map(value => value.buildAwsValue()))(_.face)
      .optionallyWith(
        matchConfidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.matchConfidence)
      .optionallyWith(knownGender.map(value => value.buildAwsValue()))(
        _.knownGender
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.Celebrity.ReadOnly =
    zio.aws.rekognition.model.Celebrity.wrap(buildAwsValue())
}
object Celebrity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.Celebrity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.Celebrity =
      zio.aws.rekognition.model.Celebrity(
        urls.map(value => value),
        name.map(value => value),
        id.map(value => value),
        face.map(value => value.asEditable),
        matchConfidence.map(value => value),
        knownGender.map(value => value.asEditable)
      )
    def urls: Option[List[Url]]
    def name: Option[String]
    def id: Option[RekognitionUniqueId]
    def face: Option[zio.aws.rekognition.model.ComparedFace.ReadOnly]
    def matchConfidence: Option[Percent]
    def knownGender: Option[zio.aws.rekognition.model.KnownGender.ReadOnly]
    def getUrls: ZIO[Any, AwsError, List[Url]] =
      AwsError.unwrapOptionField("urls", urls)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getId: ZIO[Any, AwsError, RekognitionUniqueId] =
      AwsError.unwrapOptionField("id", id)
    def getFace
        : ZIO[Any, AwsError, zio.aws.rekognition.model.ComparedFace.ReadOnly] =
      AwsError.unwrapOptionField("face", face)
    def getMatchConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("matchConfidence", matchConfidence)
    def getKnownGender
        : ZIO[Any, AwsError, zio.aws.rekognition.model.KnownGender.ReadOnly] =
      AwsError.unwrapOptionField("knownGender", knownGender)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.Celebrity
  ) extends zio.aws.rekognition.model.Celebrity.ReadOnly {
    override val urls: Option[List[Url]] = scala
      .Option(impl.urls())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.primitives.Url(item)
        }.toList
      )
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val id: Option[RekognitionUniqueId] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.rekognition.model.primitives.RekognitionUniqueId(value)
      )
    override val face: Option[zio.aws.rekognition.model.ComparedFace.ReadOnly] =
      scala
        .Option(impl.face())
        .map(value => zio.aws.rekognition.model.ComparedFace.wrap(value))
    override val matchConfidence: Option[Percent] = scala
      .Option(impl.matchConfidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val knownGender
        : Option[zio.aws.rekognition.model.KnownGender.ReadOnly] = scala
      .Option(impl.knownGender())
      .map(value => zio.aws.rekognition.model.KnownGender.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.Celebrity
  ): zio.aws.rekognition.model.Celebrity.ReadOnly = new Wrapper(impl)
}
