package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.SegmentConfidence
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TechnicalCueSegment(
    `type`: Option[zio.aws.rekognition.model.TechnicalCueType] = None,
    confidence: Option[SegmentConfidence] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.TechnicalCueSegment = {
    import TechnicalCueSegment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.TechnicalCueSegment
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        confidence.map(value =>
          SegmentConfidence.unwrap(value): java.lang.Float
        )
      )(_.confidence)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.TechnicalCueSegment.ReadOnly =
    zio.aws.rekognition.model.TechnicalCueSegment.wrap(buildAwsValue())
}
object TechnicalCueSegment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.TechnicalCueSegment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.TechnicalCueSegment =
      zio.aws.rekognition.model.TechnicalCueSegment(
        `type`.map(value => value),
        confidence.map(value => value)
      )
    def `type`: Option[zio.aws.rekognition.model.TechnicalCueType]
    def confidence: Option[SegmentConfidence]
    def getType
        : ZIO[Any, AwsError, zio.aws.rekognition.model.TechnicalCueType] =
      AwsError.unwrapOptionField("type", `type`)
    def getConfidence: ZIO[Any, AwsError, SegmentConfidence] =
      AwsError.unwrapOptionField("confidence", confidence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.TechnicalCueSegment
  ) extends zio.aws.rekognition.model.TechnicalCueSegment.ReadOnly {
    override val `type`: Option[zio.aws.rekognition.model.TechnicalCueType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.rekognition.model.TechnicalCueType.wrap(value))
    override val confidence: Option[SegmentConfidence] = scala
      .Option(impl.confidence())
      .map(value =>
        zio.aws.rekognition.model.primitives.SegmentConfidence(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.TechnicalCueSegment
  ): zio.aws.rekognition.model.TechnicalCueSegment.ReadOnly = new Wrapper(impl)
}
