package zio.aws.rekognition.model
import scala.jdk.CollectionConverters._
sealed trait ProtectiveEquipmentType {
  def unwrap: software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentType
}
object ProtectiveEquipmentType {
  def wrap(
      value: software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentType
  ): zio.aws.rekognition.model.ProtectiveEquipmentType = value match {
    case software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentType.FACE_COVER =>
      val r = FACE_COVER
      r
    case software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentType.HAND_COVER =>
      val r = HAND_COVER
      r
    case software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentType.HEAD_COVER =>
      val r = HEAD_COVER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rekognition.model.ProtectiveEquipmentType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentType =
      software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentType.UNKNOWN_TO_SDK_VERSION
  }
  case object FACE_COVER
      extends zio.aws.rekognition.model.ProtectiveEquipmentType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentType =
      software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentType.FACE_COVER
  }
  case object HAND_COVER
      extends zio.aws.rekognition.model.ProtectiveEquipmentType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentType =
      software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentType.HAND_COVER
  }
  case object HEAD_COVER
      extends zio.aws.rekognition.model.ProtectiveEquipmentType {
    override def unwrap
        : software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentType =
      software.amazon.awssdk.services.rekognition.model.ProtectiveEquipmentType.HEAD_COVER
  }
}
