package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PersonMatch(
    timestamp: Option[Timestamp] = None,
    person: Option[zio.aws.rekognition.model.PersonDetail] = None,
    faceMatches: Option[Iterable[zio.aws.rekognition.model.FaceMatch]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.PersonMatch = {
    import PersonMatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.PersonMatch
      .builder()
      .optionallyWith(
        timestamp.map(value => Timestamp.unwrap(value): java.lang.Long)
      )(_.timestamp)
      .optionallyWith(person.map(value => value.buildAwsValue()))(_.person)
      .optionallyWith(
        faceMatches.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.faceMatches)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.PersonMatch.ReadOnly =
    zio.aws.rekognition.model.PersonMatch.wrap(buildAwsValue())
}
object PersonMatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.PersonMatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.PersonMatch =
      zio.aws.rekognition.model.PersonMatch(
        timestamp.map(value => value),
        person.map(value => value.asEditable),
        faceMatches.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def timestamp: Option[Timestamp]
    def person: Option[zio.aws.rekognition.model.PersonDetail.ReadOnly]
    def faceMatches: Option[List[zio.aws.rekognition.model.FaceMatch.ReadOnly]]
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getPerson
        : ZIO[Any, AwsError, zio.aws.rekognition.model.PersonDetail.ReadOnly] =
      AwsError.unwrapOptionField("person", person)
    def getFaceMatches: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.FaceMatch.ReadOnly
    ]] = AwsError.unwrapOptionField("faceMatches", faceMatches)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.PersonMatch
  ) extends zio.aws.rekognition.model.PersonMatch.ReadOnly {
    override val timestamp: Option[Timestamp] = scala
      .Option(impl.timestamp())
      .map(value => zio.aws.rekognition.model.primitives.Timestamp(value))
    override val person
        : Option[zio.aws.rekognition.model.PersonDetail.ReadOnly] = scala
      .Option(impl.person())
      .map(value => zio.aws.rekognition.model.PersonDetail.wrap(value))
    override val faceMatches
        : Option[List[zio.aws.rekognition.model.FaceMatch.ReadOnly]] = scala
      .Option(impl.faceMatches())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.FaceMatch.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.PersonMatch
  ): zio.aws.rekognition.model.PersonMatch.ReadOnly = new Wrapper(impl)
}
