package zio.aws.rekognition.model
import java.lang.Integer
import zio.aws.rekognition.model.primitives.{PaginationToken, MaxResults, JobId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetLabelDetectionRequest(
    jobId: JobId,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[PaginationToken] = None,
    sortBy: Option[zio.aws.rekognition.model.LabelDetectionSortBy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.GetLabelDetectionRequest = {
    import GetLabelDetectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.GetLabelDetectionRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.GetLabelDetectionRequest.ReadOnly =
    zio.aws.rekognition.model.GetLabelDetectionRequest.wrap(buildAwsValue())
}
object GetLabelDetectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.GetLabelDetectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.GetLabelDetectionRequest =
      zio.aws.rekognition.model.GetLabelDetectionRequest(
        jobId,
        maxResults.map(value => value),
        nextToken.map(value => value),
        sortBy.map(value => value)
      )
    def jobId: JobId
    def maxResults: Option[MaxResults]
    def nextToken: Option[PaginationToken]
    def sortBy: Option[zio.aws.rekognition.model.LabelDetectionSortBy]
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.rekognition.model.LabelDetectionSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.GetLabelDetectionRequest
  ) extends zio.aws.rekognition.model.GetLabelDetectionRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.rekognition.model.primitives.JobId(impl.jobId())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.rekognition.model.primitives.MaxResults(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.rekognition.model.primitives.PaginationToken(value))
    override val sortBy
        : Option[zio.aws.rekognition.model.LabelDetectionSortBy] = scala
      .Option(impl.sortBy())
      .map(value => zio.aws.rekognition.model.LabelDetectionSortBy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.GetLabelDetectionRequest
  ): zio.aws.rekognition.model.GetLabelDetectionRequest.ReadOnly = new Wrapper(
    impl
  )
}
