package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DetectLabelsResponse(
    labels: Option[Iterable[zio.aws.rekognition.model.Label]] = None,
    orientationCorrection: Option[
      zio.aws.rekognition.model.OrientationCorrection
    ] = None,
    labelModelVersion: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DetectLabelsResponse = {
    import DetectLabelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DetectLabelsResponse
      .builder()
      .optionallyWith(
        labels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.labels)
      .optionallyWith(orientationCorrection.map(value => value.unwrap))(
        _.orientationCorrection
      )
      .optionallyWith(labelModelVersion.map(value => value: java.lang.String))(
        _.labelModelVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DetectLabelsResponse.ReadOnly =
    zio.aws.rekognition.model.DetectLabelsResponse.wrap(buildAwsValue())
}
object DetectLabelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DetectLabelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DetectLabelsResponse =
      zio.aws.rekognition.model.DetectLabelsResponse(
        labels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        orientationCorrection.map(value => value),
        labelModelVersion.map(value => value)
      )
    def labels: Option[List[zio.aws.rekognition.model.Label.ReadOnly]]
    def orientationCorrection
        : Option[zio.aws.rekognition.model.OrientationCorrection]
    def labelModelVersion: Option[String]
    def getLabels
        : ZIO[Any, AwsError, List[zio.aws.rekognition.model.Label.ReadOnly]] =
      AwsError.unwrapOptionField("labels", labels)
    def getOrientationCorrection
        : ZIO[Any, AwsError, zio.aws.rekognition.model.OrientationCorrection] =
      AwsError.unwrapOptionField("orientationCorrection", orientationCorrection)
    def getLabelModelVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("labelModelVersion", labelModelVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DetectLabelsResponse
  ) extends zio.aws.rekognition.model.DetectLabelsResponse.ReadOnly {
    override val labels
        : Option[List[zio.aws.rekognition.model.Label.ReadOnly]] = scala
      .Option(impl.labels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.Label.wrap(item)
        }.toList
      )
    override val orientationCorrection
        : Option[zio.aws.rekognition.model.OrientationCorrection] = scala
      .Option(impl.orientationCorrection())
      .map(value => zio.aws.rekognition.model.OrientationCorrection.wrap(value))
    override val labelModelVersion: Option[String] =
      scala.Option(impl.labelModelVersion()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DetectLabelsResponse
  ): zio.aws.rekognition.model.DetectLabelsResponse.ReadOnly = new Wrapper(impl)
}
