package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{
  RoleArn,
  DateTime,
  StreamProcessorArn,
  StreamProcessorName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeStreamProcessorResponse(
    name: Option[StreamProcessorName] = None,
    streamProcessorArn: Option[StreamProcessorArn] = None,
    status: Option[zio.aws.rekognition.model.StreamProcessorStatus] = None,
    statusMessage: Option[String] = None,
    creationTimestamp: Option[DateTime] = None,
    lastUpdateTimestamp: Option[DateTime] = None,
    input: Option[zio.aws.rekognition.model.StreamProcessorInput] = None,
    output: Option[zio.aws.rekognition.model.StreamProcessorOutput] = None,
    roleArn: Option[RoleArn] = None,
    settings: Option[zio.aws.rekognition.model.StreamProcessorSettings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DescribeStreamProcessorResponse = {
    import DescribeStreamProcessorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DescribeStreamProcessorResponse
      .builder()
      .optionallyWith(
        name.map(value => StreamProcessorName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        streamProcessorArn.map(value =>
          StreamProcessorArn.unwrap(value): java.lang.String
        )
      )(_.streamProcessorArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        creationTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTimestamp)
      .optionallyWith(
        lastUpdateTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.lastUpdateTimestamp)
      .optionallyWith(input.map(value => value.buildAwsValue()))(_.input)
      .optionallyWith(output.map(value => value.buildAwsValue()))(_.output)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(settings.map(value => value.buildAwsValue()))(_.settings)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.DescribeStreamProcessorResponse.ReadOnly =
    zio.aws.rekognition.model.DescribeStreamProcessorResponse
      .wrap(buildAwsValue())
}
object DescribeStreamProcessorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DescribeStreamProcessorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DescribeStreamProcessorResponse =
      zio.aws.rekognition.model.DescribeStreamProcessorResponse(
        name.map(value => value),
        streamProcessorArn.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        creationTimestamp.map(value => value),
        lastUpdateTimestamp.map(value => value),
        input.map(value => value.asEditable),
        output.map(value => value.asEditable),
        roleArn.map(value => value),
        settings.map(value => value.asEditable)
      )
    def name: Option[StreamProcessorName]
    def streamProcessorArn: Option[StreamProcessorArn]
    def status: Option[zio.aws.rekognition.model.StreamProcessorStatus]
    def statusMessage: Option[String]
    def creationTimestamp: Option[DateTime]
    def lastUpdateTimestamp: Option[DateTime]
    def input: Option[zio.aws.rekognition.model.StreamProcessorInput.ReadOnly]
    def output: Option[zio.aws.rekognition.model.StreamProcessorOutput.ReadOnly]
    def roleArn: Option[RoleArn]
    def settings
        : Option[zio.aws.rekognition.model.StreamProcessorSettings.ReadOnly]
    def getName: ZIO[Any, AwsError, StreamProcessorName] =
      AwsError.unwrapOptionField("name", name)
    def getStreamProcessorArn: ZIO[Any, AwsError, StreamProcessorArn] =
      AwsError.unwrapOptionField("streamProcessorArn", streamProcessorArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.rekognition.model.StreamProcessorStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getCreationTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
    def getLastUpdateTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastUpdateTimestamp", lastUpdateTimestamp)
    def getInput: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.StreamProcessorInput.ReadOnly
    ] = AwsError.unwrapOptionField("input", input)
    def getOutput: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.StreamProcessorOutput.ReadOnly
    ] = AwsError.unwrapOptionField("output", output)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getSettings: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.StreamProcessorSettings.ReadOnly
    ] = AwsError.unwrapOptionField("settings", settings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DescribeStreamProcessorResponse
  ) extends zio.aws.rekognition.model.DescribeStreamProcessorResponse.ReadOnly {
    override val name: Option[StreamProcessorName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.rekognition.model.primitives.StreamProcessorName(value)
      )
    override val streamProcessorArn: Option[StreamProcessorArn] = scala
      .Option(impl.streamProcessorArn())
      .map(value =>
        zio.aws.rekognition.model.primitives.StreamProcessorArn(value)
      )
    override val status
        : Option[zio.aws.rekognition.model.StreamProcessorStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.rekognition.model.StreamProcessorStatus.wrap(value))
    override val statusMessage: Option[String] =
      scala.Option(impl.statusMessage()).map(value => value: String)
    override val creationTimestamp: Option[DateTime] = scala
      .Option(impl.creationTimestamp())
      .map(value => zio.aws.rekognition.model.primitives.DateTime(value))
    override val lastUpdateTimestamp: Option[DateTime] = scala
      .Option(impl.lastUpdateTimestamp())
      .map(value => zio.aws.rekognition.model.primitives.DateTime(value))
    override val input
        : Option[zio.aws.rekognition.model.StreamProcessorInput.ReadOnly] =
      scala
        .Option(impl.input())
        .map(value =>
          zio.aws.rekognition.model.StreamProcessorInput.wrap(value)
        )
    override val output
        : Option[zio.aws.rekognition.model.StreamProcessorOutput.ReadOnly] =
      scala
        .Option(impl.output())
        .map(value =>
          zio.aws.rekognition.model.StreamProcessorOutput.wrap(value)
        )
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.rekognition.model.primitives.RoleArn(value))
    override val settings
        : Option[zio.aws.rekognition.model.StreamProcessorSettings.ReadOnly] =
      scala
        .Option(impl.settings())
        .map(value =>
          zio.aws.rekognition.model.StreamProcessorSettings.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DescribeStreamProcessorResponse
  ): zio.aws.rekognition.model.DescribeStreamProcessorResponse.ReadOnly =
    new Wrapper(impl)
}
