package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.CollectionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeCollectionRequest(collectionId: CollectionId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DescribeCollectionRequest = {
    import DescribeCollectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DescribeCollectionRequest
      .builder()
      .collectionId(CollectionId.unwrap(collectionId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DescribeCollectionRequest.ReadOnly =
    zio.aws.rekognition.model.DescribeCollectionRequest.wrap(buildAwsValue())
}
object DescribeCollectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DescribeCollectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DescribeCollectionRequest =
      zio.aws.rekognition.model.DescribeCollectionRequest(collectionId)
    def collectionId: CollectionId
    def getCollectionId: ZIO[Any, Nothing, CollectionId] =
      ZIO.succeed(collectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DescribeCollectionRequest
  ) extends zio.aws.rekognition.model.DescribeCollectionRequest.ReadOnly {
    override val collectionId: CollectionId =
      zio.aws.rekognition.model.primitives.CollectionId(impl.collectionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DescribeCollectionRequest
  ): zio.aws.rekognition.model.DescribeCollectionRequest.ReadOnly = new Wrapper(
    impl
  )
}
