package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{
  StatusMessage,
  DatasetArn,
  DateTime
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DatasetMetadata(
    creationTimestamp: Option[DateTime] = None,
    datasetType: Option[zio.aws.rekognition.model.DatasetType] = None,
    datasetArn: Option[DatasetArn] = None,
    status: Option[zio.aws.rekognition.model.DatasetStatus] = None,
    statusMessage: Option[StatusMessage] = None,
    statusMessageCode: Option[
      zio.aws.rekognition.model.DatasetStatusMessageCode
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DatasetMetadata = {
    import DatasetMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DatasetMetadata
      .builder()
      .optionallyWith(
        creationTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTimestamp)
      .optionallyWith(datasetType.map(value => value.unwrap))(_.datasetType)
      .optionallyWith(
        datasetArn.map(value => DatasetArn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(statusMessageCode.map(value => value.unwrap))(
        _.statusMessageCode
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DatasetMetadata.ReadOnly =
    zio.aws.rekognition.model.DatasetMetadata.wrap(buildAwsValue())
}
object DatasetMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DatasetMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DatasetMetadata =
      zio.aws.rekognition.model.DatasetMetadata(
        creationTimestamp.map(value => value),
        datasetType.map(value => value),
        datasetArn.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        statusMessageCode.map(value => value)
      )
    def creationTimestamp: Option[DateTime]
    def datasetType: Option[zio.aws.rekognition.model.DatasetType]
    def datasetArn: Option[DatasetArn]
    def status: Option[zio.aws.rekognition.model.DatasetStatus]
    def statusMessage: Option[StatusMessage]
    def statusMessageCode
        : Option[zio.aws.rekognition.model.DatasetStatusMessageCode]
    def getCreationTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
    def getDatasetType
        : ZIO[Any, AwsError, zio.aws.rekognition.model.DatasetType] =
      AwsError.unwrapOptionField("datasetType", datasetType)
    def getDatasetArn: ZIO[Any, AwsError, DatasetArn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
    def getStatus: ZIO[Any, AwsError, zio.aws.rekognition.model.DatasetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getStatusMessageCode: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.DatasetStatusMessageCode
    ] = AwsError.unwrapOptionField("statusMessageCode", statusMessageCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DatasetMetadata
  ) extends zio.aws.rekognition.model.DatasetMetadata.ReadOnly {
    override val creationTimestamp: Option[DateTime] = scala
      .Option(impl.creationTimestamp())
      .map(value => zio.aws.rekognition.model.primitives.DateTime(value))
    override val datasetType: Option[zio.aws.rekognition.model.DatasetType] =
      scala
        .Option(impl.datasetType())
        .map(value => zio.aws.rekognition.model.DatasetType.wrap(value))
    override val datasetArn: Option[DatasetArn] = scala
      .Option(impl.datasetArn())
      .map(value => zio.aws.rekognition.model.primitives.DatasetArn(value))
    override val status: Option[zio.aws.rekognition.model.DatasetStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.rekognition.model.DatasetStatus.wrap(value))
    override val statusMessage: Option[StatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value => zio.aws.rekognition.model.primitives.StatusMessage(value))
    override val statusMessageCode
        : Option[zio.aws.rekognition.model.DatasetStatusMessageCode] = scala
      .Option(impl.statusMessageCode())
      .map(value =>
        zio.aws.rekognition.model.DatasetStatusMessageCode.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DatasetMetadata
  ): zio.aws.rekognition.model.DatasetMetadata.ReadOnly = new Wrapper(impl)
}
