package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.StreamProcessorArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateStreamProcessorResponse(
    streamProcessorArn: Option[StreamProcessorArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.CreateStreamProcessorResponse = {
    import CreateStreamProcessorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.CreateStreamProcessorResponse
      .builder()
      .optionallyWith(
        streamProcessorArn.map(value =>
          StreamProcessorArn.unwrap(value): java.lang.String
        )
      )(_.streamProcessorArn)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.CreateStreamProcessorResponse.ReadOnly =
    zio.aws.rekognition.model.CreateStreamProcessorResponse
      .wrap(buildAwsValue())
}
object CreateStreamProcessorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.CreateStreamProcessorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.CreateStreamProcessorResponse =
      zio.aws.rekognition.model
        .CreateStreamProcessorResponse(streamProcessorArn.map(value => value))
    def streamProcessorArn: Option[StreamProcessorArn]
    def getStreamProcessorArn: ZIO[Any, AwsError, StreamProcessorArn] =
      AwsError.unwrapOptionField("streamProcessorArn", streamProcessorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.CreateStreamProcessorResponse
  ) extends zio.aws.rekognition.model.CreateStreamProcessorResponse.ReadOnly {
    override val streamProcessorArn: Option[StreamProcessorArn] = scala
      .Option(impl.streamProcessorArn())
      .map(value =>
        zio.aws.rekognition.model.primitives.StreamProcessorArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.CreateStreamProcessorResponse
  ): zio.aws.rekognition.model.CreateStreamProcessorResponse.ReadOnly =
    new Wrapper(impl)
}
