package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Percent
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CompareFacesMatch(
    similarity: Option[Percent] = None,
    face: Option[zio.aws.rekognition.model.ComparedFace] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.CompareFacesMatch = {
    import CompareFacesMatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.CompareFacesMatch
      .builder()
      .optionallyWith(
        similarity.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.similarity)
      .optionallyWith(face.map(value => value.buildAwsValue()))(_.face)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.CompareFacesMatch.ReadOnly =
    zio.aws.rekognition.model.CompareFacesMatch.wrap(buildAwsValue())
}
object CompareFacesMatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.CompareFacesMatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.CompareFacesMatch =
      zio.aws.rekognition.model.CompareFacesMatch(
        similarity.map(value => value),
        face.map(value => value.asEditable)
      )
    def similarity: Option[Percent]
    def face: Option[zio.aws.rekognition.model.ComparedFace.ReadOnly]
    def getSimilarity: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("similarity", similarity)
    def getFace
        : ZIO[Any, AwsError, zio.aws.rekognition.model.ComparedFace.ReadOnly] =
      AwsError.unwrapOptionField("face", face)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.CompareFacesMatch
  ) extends zio.aws.rekognition.model.CompareFacesMatch.ReadOnly {
    override val similarity: Option[Percent] = scala
      .Option(impl.similarity())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val face: Option[zio.aws.rekognition.model.ComparedFace.ReadOnly] =
      scala
        .Option(impl.face())
        .map(value => zio.aws.rekognition.model.ComparedFace.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.CompareFacesMatch
  ): zio.aws.rekognition.model.CompareFacesMatch.ReadOnly = new Wrapper(impl)
}
