package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{Percent, RekognitionUniqueId, Url}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CelebrityDetail(
    urls: Option[Iterable[Url]] = None,
    name: Option[String] = None,
    id: Option[RekognitionUniqueId] = None,
    confidence: Option[Percent] = None,
    boundingBox: Option[zio.aws.rekognition.model.BoundingBox] = None,
    face: Option[zio.aws.rekognition.model.FaceDetail] = None,
    knownGender: Option[zio.aws.rekognition.model.KnownGender] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.CelebrityDetail = {
    import CelebrityDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.CelebrityDetail
      .builder()
      .optionallyWith(
        urls.map(value =>
          value.map { item =>
            Url.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.urls)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        id.map(value => RekognitionUniqueId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .optionallyWith(boundingBox.map(value => value.buildAwsValue()))(
        _.boundingBox
      )
      .optionallyWith(face.map(value => value.buildAwsValue()))(_.face)
      .optionallyWith(knownGender.map(value => value.buildAwsValue()))(
        _.knownGender
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.CelebrityDetail.ReadOnly =
    zio.aws.rekognition.model.CelebrityDetail.wrap(buildAwsValue())
}
object CelebrityDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.CelebrityDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.CelebrityDetail =
      zio.aws.rekognition.model.CelebrityDetail(
        urls.map(value => value),
        name.map(value => value),
        id.map(value => value),
        confidence.map(value => value),
        boundingBox.map(value => value.asEditable),
        face.map(value => value.asEditable),
        knownGender.map(value => value.asEditable)
      )
    def urls: Option[List[Url]]
    def name: Option[String]
    def id: Option[RekognitionUniqueId]
    def confidence: Option[Percent]
    def boundingBox: Option[zio.aws.rekognition.model.BoundingBox.ReadOnly]
    def face: Option[zio.aws.rekognition.model.FaceDetail.ReadOnly]
    def knownGender: Option[zio.aws.rekognition.model.KnownGender.ReadOnly]
    def getUrls: ZIO[Any, AwsError, List[Url]] =
      AwsError.unwrapOptionField("urls", urls)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getId: ZIO[Any, AwsError, RekognitionUniqueId] =
      AwsError.unwrapOptionField("id", id)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getBoundingBox
        : ZIO[Any, AwsError, zio.aws.rekognition.model.BoundingBox.ReadOnly] =
      AwsError.unwrapOptionField("boundingBox", boundingBox)
    def getFace
        : ZIO[Any, AwsError, zio.aws.rekognition.model.FaceDetail.ReadOnly] =
      AwsError.unwrapOptionField("face", face)
    def getKnownGender
        : ZIO[Any, AwsError, zio.aws.rekognition.model.KnownGender.ReadOnly] =
      AwsError.unwrapOptionField("knownGender", knownGender)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.CelebrityDetail
  ) extends zio.aws.rekognition.model.CelebrityDetail.ReadOnly {
    override val urls: Option[List[Url]] = scala
      .Option(impl.urls())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.primitives.Url(item)
        }.toList
      )
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val id: Option[RekognitionUniqueId] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.rekognition.model.primitives.RekognitionUniqueId(value)
      )
    override val confidence: Option[Percent] = scala
      .Option(impl.confidence())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val boundingBox
        : Option[zio.aws.rekognition.model.BoundingBox.ReadOnly] = scala
      .Option(impl.boundingBox())
      .map(value => zio.aws.rekognition.model.BoundingBox.wrap(value))
    override val face: Option[zio.aws.rekognition.model.FaceDetail.ReadOnly] =
      scala
        .Option(impl.face())
        .map(value => zio.aws.rekognition.model.FaceDetail.wrap(value))
    override val knownGender
        : Option[zio.aws.rekognition.model.KnownGender.ReadOnly] = scala
      .Option(impl.knownGender())
      .map(value => zio.aws.rekognition.model.KnownGender.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.CelebrityDetail
  ): zio.aws.rekognition.model.CelebrityDetail.ReadOnly = new Wrapper(impl)
}
