package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StreamProcessorSettings(
    faceSearch: Option[zio.aws.rekognition.model.FaceSearchSettings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StreamProcessorSettings = {
    import StreamProcessorSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StreamProcessorSettings
      .builder()
      .optionallyWith(faceSearch.map(value => value.buildAwsValue()))(
        _.faceSearch
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.StreamProcessorSettings.ReadOnly =
    zio.aws.rekognition.model.StreamProcessorSettings.wrap(buildAwsValue())
}
object StreamProcessorSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StreamProcessorSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StreamProcessorSettings =
      zio.aws.rekognition.model
        .StreamProcessorSettings(faceSearch.map(value => value.asEditable))
    def faceSearch
        : Option[zio.aws.rekognition.model.FaceSearchSettings.ReadOnly]
    def getFaceSearch: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.FaceSearchSettings.ReadOnly
    ] = AwsError.unwrapOptionField("faceSearch", faceSearch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StreamProcessorSettings
  ) extends zio.aws.rekognition.model.StreamProcessorSettings.ReadOnly {
    override val faceSearch
        : Option[zio.aws.rekognition.model.FaceSearchSettings.ReadOnly] = scala
      .Option(impl.faceSearch())
      .map(value => zio.aws.rekognition.model.FaceSearchSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StreamProcessorSettings
  ): zio.aws.rekognition.model.StreamProcessorSettings.ReadOnly = new Wrapper(
    impl
  )
}
