package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartSegmentDetectionFilters(
    technicalCueFilter: Option[
      zio.aws.rekognition.model.StartTechnicalCueDetectionFilter
    ] = None,
    shotFilter: Option[zio.aws.rekognition.model.StartShotDetectionFilter] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.StartSegmentDetectionFilters = {
    import StartSegmentDetectionFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.StartSegmentDetectionFilters
      .builder()
      .optionallyWith(technicalCueFilter.map(value => value.buildAwsValue()))(
        _.technicalCueFilter
      )
      .optionallyWith(shotFilter.map(value => value.buildAwsValue()))(
        _.shotFilter
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.StartSegmentDetectionFilters.ReadOnly =
    zio.aws.rekognition.model.StartSegmentDetectionFilters.wrap(buildAwsValue())
}
object StartSegmentDetectionFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.StartSegmentDetectionFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.StartSegmentDetectionFilters =
      zio.aws.rekognition.model.StartSegmentDetectionFilters(
        technicalCueFilter.map(value => value.asEditable),
        shotFilter.map(value => value.asEditable)
      )
    def technicalCueFilter: Option[
      zio.aws.rekognition.model.StartTechnicalCueDetectionFilter.ReadOnly
    ]
    def shotFilter
        : Option[zio.aws.rekognition.model.StartShotDetectionFilter.ReadOnly]
    def getTechnicalCueFilter: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.StartTechnicalCueDetectionFilter.ReadOnly
    ] = AwsError.unwrapOptionField("technicalCueFilter", technicalCueFilter)
    def getShotFilter: ZIO[
      Any,
      AwsError,
      zio.aws.rekognition.model.StartShotDetectionFilter.ReadOnly
    ] = AwsError.unwrapOptionField("shotFilter", shotFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.StartSegmentDetectionFilters
  ) extends zio.aws.rekognition.model.StartSegmentDetectionFilters.ReadOnly {
    override val technicalCueFilter: Option[
      zio.aws.rekognition.model.StartTechnicalCueDetectionFilter.ReadOnly
    ] = scala
      .Option(impl.technicalCueFilter())
      .map(value =>
        zio.aws.rekognition.model.StartTechnicalCueDetectionFilter.wrap(value)
      )
    override val shotFilter
        : Option[zio.aws.rekognition.model.StartShotDetectionFilter.ReadOnly] =
      scala
        .Option(impl.shotFilter())
        .map(value =>
          zio.aws.rekognition.model.StartShotDetectionFilter.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.StartSegmentDetectionFilters
  ): zio.aws.rekognition.model.StartSegmentDetectionFilters.ReadOnly =
    new Wrapper(impl)
}
