package zio.aws.rekognition.model
import java.lang.Integer
import zio.aws.rekognition.model.primitives.{
  Percent,
  MaxFaces,
  FaceId,
  CollectionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SearchFacesRequest(
    collectionId: CollectionId,
    faceId: FaceId,
    maxFaces: Option[MaxFaces] = None,
    faceMatchThreshold: Option[Percent] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.SearchFacesRequest = {
    import SearchFacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.SearchFacesRequest
      .builder()
      .collectionId(CollectionId.unwrap(collectionId): java.lang.String)
      .faceId(FaceId.unwrap(faceId): java.lang.String)
      .optionallyWith(maxFaces.map(value => MaxFaces.unwrap(value): Integer))(
        _.maxFaces
      )
      .optionallyWith(
        faceMatchThreshold.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.faceMatchThreshold)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.SearchFacesRequest.ReadOnly =
    zio.aws.rekognition.model.SearchFacesRequest.wrap(buildAwsValue())
}
object SearchFacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.SearchFacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.SearchFacesRequest =
      zio.aws.rekognition.model.SearchFacesRequest(
        collectionId,
        faceId,
        maxFaces.map(value => value),
        faceMatchThreshold.map(value => value)
      )
    def collectionId: CollectionId
    def faceId: FaceId
    def maxFaces: Option[MaxFaces]
    def faceMatchThreshold: Option[Percent]
    def getCollectionId: ZIO[Any, Nothing, CollectionId] =
      ZIO.succeed(collectionId)
    def getFaceId: ZIO[Any, Nothing, FaceId] = ZIO.succeed(faceId)
    def getMaxFaces: ZIO[Any, AwsError, MaxFaces] =
      AwsError.unwrapOptionField("maxFaces", maxFaces)
    def getFaceMatchThreshold: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("faceMatchThreshold", faceMatchThreshold)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.SearchFacesRequest
  ) extends zio.aws.rekognition.model.SearchFacesRequest.ReadOnly {
    override val collectionId: CollectionId =
      zio.aws.rekognition.model.primitives.CollectionId(impl.collectionId())
    override val faceId: FaceId =
      zio.aws.rekognition.model.primitives.FaceId(impl.faceId())
    override val maxFaces: Option[MaxFaces] = scala
      .Option(impl.maxFaces())
      .map(value => zio.aws.rekognition.model.primitives.MaxFaces(value))
    override val faceMatchThreshold: Option[Percent] = scala
      .Option(impl.faceMatchThreshold())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.SearchFacesRequest
  ): zio.aws.rekognition.model.SearchFacesRequest.ReadOnly = new Wrapper(impl)
}
