package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{RoleArn, SNSTopicArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class NotificationChannel(
    snsTopicArn: SNSTopicArn,
    roleArn: RoleArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.NotificationChannel = {
    import NotificationChannel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.NotificationChannel
      .builder()
      .snsTopicArn(SNSTopicArn.unwrap(snsTopicArn): java.lang.String)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.NotificationChannel.ReadOnly =
    zio.aws.rekognition.model.NotificationChannel.wrap(buildAwsValue())
}
object NotificationChannel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.NotificationChannel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.NotificationChannel =
      zio.aws.rekognition.model.NotificationChannel(snsTopicArn, roleArn)
    def snsTopicArn: SNSTopicArn
    def roleArn: RoleArn
    def getSnsTopicArn: ZIO[Any, Nothing, SNSTopicArn] =
      ZIO.succeed(snsTopicArn)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.NotificationChannel
  ) extends zio.aws.rekognition.model.NotificationChannel.ReadOnly {
    override val snsTopicArn: SNSTopicArn =
      zio.aws.rekognition.model.primitives.SNSTopicArn(impl.snsTopicArn())
    override val roleArn: RoleArn =
      zio.aws.rekognition.model.primitives.RoleArn(impl.roleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.NotificationChannel
  ): zio.aws.rekognition.model.NotificationChannel.ReadOnly = new Wrapper(impl)
}
