package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListFacesResponse(
    faces: Option[Iterable[zio.aws.rekognition.model.Face]] = None,
    nextToken: Option[String] = None,
    faceModelVersion: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ListFacesResponse = {
    import ListFacesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ListFacesResponse
      .builder()
      .optionallyWith(
        faces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.faces)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(faceModelVersion.map(value => value: java.lang.String))(
        _.faceModelVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.ListFacesResponse.ReadOnly =
    zio.aws.rekognition.model.ListFacesResponse.wrap(buildAwsValue())
}
object ListFacesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ListFacesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ListFacesResponse =
      zio.aws.rekognition.model.ListFacesResponse(
        faces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        faceModelVersion.map(value => value)
      )
    def faces: Option[List[zio.aws.rekognition.model.Face.ReadOnly]]
    def nextToken: Option[String]
    def faceModelVersion: Option[String]
    def getFaces
        : ZIO[Any, AwsError, List[zio.aws.rekognition.model.Face.ReadOnly]] =
      AwsError.unwrapOptionField("faces", faces)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFaceModelVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("faceModelVersion", faceModelVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ListFacesResponse
  ) extends zio.aws.rekognition.model.ListFacesResponse.ReadOnly {
    override val faces: Option[List[zio.aws.rekognition.model.Face.ReadOnly]] =
      scala
        .Option(impl.faces())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rekognition.model.Face.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val faceModelVersion: Option[String] =
      scala.Option(impl.faceModelVersion()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ListFacesResponse
  ): zio.aws.rekognition.model.ListFacesResponse.ReadOnly = new Wrapper(impl)
}
