package zio.aws.rekognition.model
import java.lang.Integer
import zio.aws.rekognition.model.primitives.{
  PageSize,
  PaginationToken,
  CollectionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListFacesRequest(
    collectionId: CollectionId,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[PageSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.ListFacesRequest = {
    import ListFacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.ListFacesRequest
      .builder()
      .collectionId(CollectionId.unwrap(collectionId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.ListFacesRequest.ReadOnly =
    zio.aws.rekognition.model.ListFacesRequest.wrap(buildAwsValue())
}
object ListFacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.ListFacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.ListFacesRequest =
      zio.aws.rekognition.model.ListFacesRequest(
        collectionId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def collectionId: CollectionId
    def nextToken: Option[PaginationToken]
    def maxResults: Option[PageSize]
    def getCollectionId: ZIO[Any, Nothing, CollectionId] =
      ZIO.succeed(collectionId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.ListFacesRequest
  ) extends zio.aws.rekognition.model.ListFacesRequest.ReadOnly {
    override val collectionId: CollectionId =
      zio.aws.rekognition.model.primitives.CollectionId(impl.collectionId())
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.rekognition.model.primitives.PaginationToken(value))
    override val maxResults: Option[PageSize] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.rekognition.model.primitives.PageSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.ListFacesRequest
  ): zio.aws.rekognition.model.ListFacesRequest.ReadOnly = new Wrapper(impl)
}
