package zio.aws.rekognition.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GroundTruthManifest(
    s3Object: Option[zio.aws.rekognition.model.S3Object] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.GroundTruthManifest = {
    import GroundTruthManifest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.GroundTruthManifest
      .builder()
      .optionallyWith(s3Object.map(value => value.buildAwsValue()))(_.s3Object)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.GroundTruthManifest.ReadOnly =
    zio.aws.rekognition.model.GroundTruthManifest.wrap(buildAwsValue())
}
object GroundTruthManifest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.GroundTruthManifest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.GroundTruthManifest =
      zio.aws.rekognition.model
        .GroundTruthManifest(s3Object.map(value => value.asEditable))
    def s3Object: Option[zio.aws.rekognition.model.S3Object.ReadOnly]
    def getS3Object
        : ZIO[Any, AwsError, zio.aws.rekognition.model.S3Object.ReadOnly] =
      AwsError.unwrapOptionField("s3Object", s3Object)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.GroundTruthManifest
  ) extends zio.aws.rekognition.model.GroundTruthManifest.ReadOnly {
    override val s3Object: Option[zio.aws.rekognition.model.S3Object.ReadOnly] =
      scala
        .Option(impl.s3Object())
        .map(value => zio.aws.rekognition.model.S3Object.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.GroundTruthManifest
  ): zio.aws.rekognition.model.GroundTruthManifest.ReadOnly = new Wrapper(impl)
}
