package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.{PaginationToken, StatusMessage}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetContentModerationResponse(
    jobStatus: Option[zio.aws.rekognition.model.VideoJobStatus] = None,
    statusMessage: Option[StatusMessage] = None,
    videoMetadata: Option[zio.aws.rekognition.model.VideoMetadata] = None,
    moderationLabels: Option[
      Iterable[zio.aws.rekognition.model.ContentModerationDetection]
    ] = None,
    nextToken: Option[PaginationToken] = None,
    moderationModelVersion: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.GetContentModerationResponse = {
    import GetContentModerationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.GetContentModerationResponse
      .builder()
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(videoMetadata.map(value => value.buildAwsValue()))(
        _.videoMetadata
      )
      .optionallyWith(
        moderationLabels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.moderationLabels)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        moderationModelVersion.map(value => value: java.lang.String)
      )(_.moderationModelVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.GetContentModerationResponse.ReadOnly =
    zio.aws.rekognition.model.GetContentModerationResponse.wrap(buildAwsValue())
}
object GetContentModerationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.GetContentModerationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.GetContentModerationResponse =
      zio.aws.rekognition.model.GetContentModerationResponse(
        jobStatus.map(value => value),
        statusMessage.map(value => value),
        videoMetadata.map(value => value.asEditable),
        moderationLabels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        moderationModelVersion.map(value => value)
      )
    def jobStatus: Option[zio.aws.rekognition.model.VideoJobStatus]
    def statusMessage: Option[StatusMessage]
    def videoMetadata: Option[zio.aws.rekognition.model.VideoMetadata.ReadOnly]
    def moderationLabels: Option[
      List[zio.aws.rekognition.model.ContentModerationDetection.ReadOnly]
    ]
    def nextToken: Option[PaginationToken]
    def moderationModelVersion: Option[String]
    def getJobStatus
        : ZIO[Any, AwsError, zio.aws.rekognition.model.VideoJobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getVideoMetadata
        : ZIO[Any, AwsError, zio.aws.rekognition.model.VideoMetadata.ReadOnly] =
      AwsError.unwrapOptionField("videoMetadata", videoMetadata)
    def getModerationLabels: ZIO[Any, AwsError, List[
      zio.aws.rekognition.model.ContentModerationDetection.ReadOnly
    ]] = AwsError.unwrapOptionField("moderationLabels", moderationLabels)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getModerationModelVersion: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("moderationModelVersion", moderationModelVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.GetContentModerationResponse
  ) extends zio.aws.rekognition.model.GetContentModerationResponse.ReadOnly {
    override val jobStatus: Option[zio.aws.rekognition.model.VideoJobStatus] =
      scala
        .Option(impl.jobStatus())
        .map(value => zio.aws.rekognition.model.VideoJobStatus.wrap(value))
    override val statusMessage: Option[StatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value => zio.aws.rekognition.model.primitives.StatusMessage(value))
    override val videoMetadata
        : Option[zio.aws.rekognition.model.VideoMetadata.ReadOnly] = scala
      .Option(impl.videoMetadata())
      .map(value => zio.aws.rekognition.model.VideoMetadata.wrap(value))
    override val moderationLabels: Option[
      List[zio.aws.rekognition.model.ContentModerationDetection.ReadOnly]
    ] = scala
      .Option(impl.moderationLabels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rekognition.model.ContentModerationDetection.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.rekognition.model.primitives.PaginationToken(value))
    override val moderationModelVersion: Option[String] =
      scala.Option(impl.moderationModelVersion()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.GetContentModerationResponse
  ): zio.aws.rekognition.model.GetContentModerationResponse.ReadOnly =
    new Wrapper(impl)
}
