package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.StreamProcessorName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeStreamProcessorRequest(name: StreamProcessorName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DescribeStreamProcessorRequest = {
    import DescribeStreamProcessorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DescribeStreamProcessorRequest
      .builder()
      .name(StreamProcessorName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.rekognition.model.DescribeStreamProcessorRequest.ReadOnly =
    zio.aws.rekognition.model.DescribeStreamProcessorRequest
      .wrap(buildAwsValue())
}
object DescribeStreamProcessorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DescribeStreamProcessorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DescribeStreamProcessorRequest =
      zio.aws.rekognition.model.DescribeStreamProcessorRequest(name)
    def name: StreamProcessorName
    def getName: ZIO[Any, Nothing, StreamProcessorName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DescribeStreamProcessorRequest
  ) extends zio.aws.rekognition.model.DescribeStreamProcessorRequest.ReadOnly {
    override val name: StreamProcessorName =
      zio.aws.rekognition.model.primitives.StreamProcessorName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DescribeStreamProcessorRequest
  ): zio.aws.rekognition.model.DescribeStreamProcessorRequest.ReadOnly =
    new Wrapper(impl)
}
