package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.ProjectArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteProjectRequest(projectArn: ProjectArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.DeleteProjectRequest = {
    import DeleteProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.DeleteProjectRequest
      .builder()
      .projectArn(ProjectArn.unwrap(projectArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.DeleteProjectRequest.ReadOnly =
    zio.aws.rekognition.model.DeleteProjectRequest.wrap(buildAwsValue())
}
object DeleteProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.DeleteProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.DeleteProjectRequest =
      zio.aws.rekognition.model.DeleteProjectRequest(projectArn)
    def projectArn: ProjectArn
    def getProjectArn: ZIO[Any, Nothing, ProjectArn] = ZIO.succeed(projectArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.DeleteProjectRequest
  ) extends zio.aws.rekognition.model.DeleteProjectRequest.ReadOnly {
    override val projectArn: ProjectArn =
      zio.aws.rekognition.model.primitives.ProjectArn(impl.projectArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.DeleteProjectRequest
  ): zio.aws.rekognition.model.DeleteProjectRequest.ReadOnly = new Wrapper(impl)
}
