package zio.aws.rekognition.model
import zio.aws.rekognition.model.primitives.Percent
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CompareFacesRequest(
    sourceImage: zio.aws.rekognition.model.Image,
    targetImage: zio.aws.rekognition.model.Image,
    similarityThreshold: Option[Percent] = None,
    qualityFilter: Option[zio.aws.rekognition.model.QualityFilter] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rekognition.model.CompareFacesRequest = {
    import CompareFacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rekognition.model.CompareFacesRequest
      .builder()
      .sourceImage(sourceImage.buildAwsValue())
      .targetImage(targetImage.buildAwsValue())
      .optionallyWith(
        similarityThreshold.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.similarityThreshold)
      .optionallyWith(qualityFilter.map(value => value.unwrap))(_.qualityFilter)
      .build()
  }
  def asReadOnly: zio.aws.rekognition.model.CompareFacesRequest.ReadOnly =
    zio.aws.rekognition.model.CompareFacesRequest.wrap(buildAwsValue())
}
object CompareFacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rekognition.model.CompareFacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rekognition.model.CompareFacesRequest =
      zio.aws.rekognition.model.CompareFacesRequest(
        sourceImage.asEditable,
        targetImage.asEditable,
        similarityThreshold.map(value => value),
        qualityFilter.map(value => value)
      )
    def sourceImage: zio.aws.rekognition.model.Image.ReadOnly
    def targetImage: zio.aws.rekognition.model.Image.ReadOnly
    def similarityThreshold: Option[Percent]
    def qualityFilter: Option[zio.aws.rekognition.model.QualityFilter]
    def getSourceImage
        : ZIO[Any, Nothing, zio.aws.rekognition.model.Image.ReadOnly] =
      ZIO.succeed(sourceImage)
    def getTargetImage
        : ZIO[Any, Nothing, zio.aws.rekognition.model.Image.ReadOnly] =
      ZIO.succeed(targetImage)
    def getSimilarityThreshold: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("similarityThreshold", similarityThreshold)
    def getQualityFilter
        : ZIO[Any, AwsError, zio.aws.rekognition.model.QualityFilter] =
      AwsError.unwrapOptionField("qualityFilter", qualityFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rekognition.model.CompareFacesRequest
  ) extends zio.aws.rekognition.model.CompareFacesRequest.ReadOnly {
    override val sourceImage: zio.aws.rekognition.model.Image.ReadOnly =
      zio.aws.rekognition.model.Image.wrap(impl.sourceImage())
    override val targetImage: zio.aws.rekognition.model.Image.ReadOnly =
      zio.aws.rekognition.model.Image.wrap(impl.targetImage())
    override val similarityThreshold: Option[Percent] = scala
      .Option(impl.similarityThreshold())
      .map(value => zio.aws.rekognition.model.primitives.Percent(value))
    override val qualityFilter
        : Option[zio.aws.rekognition.model.QualityFilter] = scala
      .Option(impl.qualityFilter())
      .map(value => zio.aws.rekognition.model.QualityFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rekognition.model.CompareFacesRequest
  ): zio.aws.rekognition.model.CompareFacesRequest.ReadOnly = new Wrapper(impl)
}
