package zio.aws.redshiftserverless
import zio.prelude.Subtype
import zio.aws.redshiftserverless.model.primitives.{
  SubnetId,
  IamRoleArn,
  SecurityGroupId,
  VpcSecurityGroupId,
  TagKey
}
import java.time.Instant
import zio.aws.redshiftserverless.model.primitives.CustomDomainCertificateArnString.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AmazonResourceName extends Subtype[String]
    type AmazonResourceName =
      zio.aws.redshiftserverless.model.primitives.AmazonResourceName.Type
    object CustomDomainCertificateArnString extends Subtype[String]
    type CustomDomainCertificateArnString =
      zio.aws.redshiftserverless.model.primitives.CustomDomainCertificateArnString.Type
    object CustomDomainName extends Subtype[String]
    type CustomDomainName =
      zio.aws.redshiftserverless.model.primitives.CustomDomainName.Type
    object DbName extends Subtype[String]
    type DbName = zio.aws.redshiftserverless.model.primitives.DbName.Type
    object DbPassword extends Subtype[String]
    type DbPassword =
      zio.aws.redshiftserverless.model.primitives.DbPassword.Type
    object DbUser extends Subtype[String]
    type DbUser = zio.aws.redshiftserverless.model.primitives.DbUser.Type
    object IamRoleArn extends Subtype[String]
    type IamRoleArn =
      zio.aws.redshiftserverless.model.primitives.IamRoleArn.Type
    type Integer = Int
    object KmsKeyId extends Subtype[String]
    type KmsKeyId = zio.aws.redshiftserverless.model.primitives.KmsKeyId.Type
    object ListCustomDomainAssociationsRequestMaxResultsInteger
        extends Subtype[Int]
    type ListCustomDomainAssociationsRequestMaxResultsInteger =
      zio.aws.redshiftserverless.model.primitives.ListCustomDomainAssociationsRequestMaxResultsInteger.Type
    object ListEndpointAccessRequestMaxResultsInteger extends Subtype[Int]
    type ListEndpointAccessRequestMaxResultsInteger =
      zio.aws.redshiftserverless.model.primitives.ListEndpointAccessRequestMaxResultsInteger.Type
    object ListNamespacesRequestMaxResultsInteger extends Subtype[Int]
    type ListNamespacesRequestMaxResultsInteger =
      zio.aws.redshiftserverless.model.primitives.ListNamespacesRequestMaxResultsInteger.Type
    object ListRecoveryPointsRequestMaxResultsInteger extends Subtype[Int]
    type ListRecoveryPointsRequestMaxResultsInteger =
      zio.aws.redshiftserverless.model.primitives.ListRecoveryPointsRequestMaxResultsInteger.Type
    object ListSnapshotsRequestMaxResultsInteger extends Subtype[Int]
    type ListSnapshotsRequestMaxResultsInteger =
      zio.aws.redshiftserverless.model.primitives.ListSnapshotsRequestMaxResultsInteger.Type
    object ListTableRestoreStatusRequestMaxResultsInteger extends Subtype[Int]
    type ListTableRestoreStatusRequestMaxResultsInteger =
      zio.aws.redshiftserverless.model.primitives.ListTableRestoreStatusRequestMaxResultsInteger.Type
    object ListUsageLimitsRequestMaxResultsInteger extends Subtype[Int]
    type ListUsageLimitsRequestMaxResultsInteger =
      zio.aws.redshiftserverless.model.primitives.ListUsageLimitsRequestMaxResultsInteger.Type
    object ListWorkgroupsRequestMaxResultsInteger extends Subtype[Int]
    type ListWorkgroupsRequestMaxResultsInteger =
      zio.aws.redshiftserverless.model.primitives.ListWorkgroupsRequestMaxResultsInteger.Type
    object NamespaceName extends Subtype[String]
    type NamespaceName =
      zio.aws.redshiftserverless.model.primitives.NamespaceName.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken =
      zio.aws.redshiftserverless.model.primitives.PaginationToken.Type
    object ParameterKey extends Subtype[String]
    type ParameterKey =
      zio.aws.redshiftserverless.model.primitives.ParameterKey.Type
    object ParameterValue extends Subtype[String]
    type ParameterValue =
      zio.aws.redshiftserverless.model.primitives.ParameterValue.Type
    object SecurityGroupId extends Subtype[String]
    type SecurityGroupId =
      zio.aws.redshiftserverless.model.primitives.SecurityGroupId.Type
    object SubnetId extends Subtype[String]
    type SubnetId = zio.aws.redshiftserverless.model.primitives.SubnetId.Type
    object SyntheticTimestamp_date_time extends Subtype[Instant]
    type SyntheticTimestamp_date_time =
      zio.aws.redshiftserverless.model.primitives.SyntheticTimestamp_date_time.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.redshiftserverless.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.redshiftserverless.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.redshiftserverless.model.primitives.Timestamp.Type
    object VpcSecurityGroupId extends Subtype[String]
    type VpcSecurityGroupId =
      zio.aws.redshiftserverless.model.primitives.VpcSecurityGroupId.Type
    object WorkgroupName extends Subtype[String]
    type WorkgroupName =
      zio.aws.redshiftserverless.model.primitives.WorkgroupName.Type
  }
  type AccountIdList = List[String]
  type AssociationList = List[zio.aws.redshiftserverless.model.Association]
  type ConfigParameterList =
    List[zio.aws.redshiftserverless.model.ConfigParameter]
  type EndpointAccessList =
    List[zio.aws.redshiftserverless.model.EndpointAccess]
  type IamRoleArnList = List[IamRoleArn]
  type LogExportList = List[zio.aws.redshiftserverless.model.LogExport]
  type NamespaceList = List[zio.aws.redshiftserverless.model.Namespace]
  type NetworkInterfaceList =
    List[zio.aws.redshiftserverless.model.NetworkInterface]
  type RecoveryPointList = List[zio.aws.redshiftserverless.model.RecoveryPoint]
  type SecurityGroupIdList = List[SecurityGroupId]
  type SnapshotList = List[zio.aws.redshiftserverless.model.Snapshot]
  type SubnetIdList = List[SubnetId]
  type TableRestoreStatusList =
    List[zio.aws.redshiftserverless.model.TableRestoreStatus]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.redshiftserverless.model.Tag]
  type UsageLimits = List[zio.aws.redshiftserverless.model.UsageLimit]
  type VpcEndpointList = List[zio.aws.redshiftserverless.model.VpcEndpoint]
  type VpcSecurityGroupIdList = List[VpcSecurityGroupId]
  type VpcSecurityGroupMembershipList =
    List[zio.aws.redshiftserverless.model.VpcSecurityGroupMembership]
  type WorkgroupList = List[zio.aws.redshiftserverless.model.Workgroup]
}
