package zio.aws.redshiftserverless.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.redshiftserverless.model.primitives.{
  SubnetId,
  SecurityGroupId,
  WorkgroupName,
  SyntheticTimestamp_date_time,
  Integer,
  CustomDomainCertificateArnString,
  CustomDomainName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Workgroup(
    baseCapacity: Optional[Integer] = Optional.Absent,
    configParameters: Optional[
      Iterable[zio.aws.redshiftserverless.model.ConfigParameter]
    ] = Optional.Absent,
    creationDate: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    customDomainCertificateArn: Optional[CustomDomainCertificateArnString] =
      Optional.Absent,
    customDomainCertificateExpiryTime: Optional[SyntheticTimestamp_date_time] =
      Optional.Absent,
    customDomainName: Optional[CustomDomainName] = Optional.Absent,
    endpoint: Optional[zio.aws.redshiftserverless.model.Endpoint] =
      Optional.Absent,
    enhancedVpcRouting: Optional[Boolean] = Optional.Absent,
    namespaceName: Optional[String] = Optional.Absent,
    patchVersion: Optional[String] = Optional.Absent,
    port: Optional[Integer] = Optional.Absent,
    publiclyAccessible: Optional[Boolean] = Optional.Absent,
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    status: Optional[zio.aws.redshiftserverless.model.WorkgroupStatus] =
      Optional.Absent,
    subnetIds: Optional[Iterable[SubnetId]] = Optional.Absent,
    workgroupArn: Optional[String] = Optional.Absent,
    workgroupId: Optional[String] = Optional.Absent,
    workgroupName: Optional[WorkgroupName] = Optional.Absent,
    workgroupVersion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.Workgroup = {
    import Workgroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.Workgroup
      .builder()
      .optionallyWith(baseCapacity.map(value => value: java.lang.Integer))(
        _.baseCapacity
      )
      .optionallyWith(
        configParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configParameters)
      .optionallyWith(
        creationDate.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.creationDate)
      .optionallyWith(
        customDomainCertificateArn.map(value =>
          CustomDomainCertificateArnString.unwrap(value): java.lang.String
        )
      )(_.customDomainCertificateArn)
      .optionallyWith(
        customDomainCertificateExpiryTime.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.customDomainCertificateExpiryTime)
      .optionallyWith(
        customDomainName.map(value =>
          CustomDomainName.unwrap(value): java.lang.String
        )
      )(_.customDomainName)
      .optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint)
      .optionallyWith(
        enhancedVpcRouting.map(value => value: java.lang.Boolean)
      )(_.enhancedVpcRouting)
      .optionallyWith(namespaceName.map(value => value: java.lang.String))(
        _.namespaceName
      )
      .optionallyWith(patchVersion.map(value => value: java.lang.String))(
        _.patchVersion
      )
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(workgroupArn.map(value => value: java.lang.String))(
        _.workgroupArn
      )
      .optionallyWith(workgroupId.map(value => value: java.lang.String))(
        _.workgroupId
      )
      .optionallyWith(
        workgroupName.map(value =>
          WorkgroupName.unwrap(value): java.lang.String
        )
      )(_.workgroupName)
      .optionallyWith(workgroupVersion.map(value => value: java.lang.String))(
        _.workgroupVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.redshiftserverless.model.Workgroup.ReadOnly =
    zio.aws.redshiftserverless.model.Workgroup.wrap(buildAwsValue())
}
object Workgroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.Workgroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.Workgroup =
      zio.aws.redshiftserverless.model.Workgroup(
        baseCapacity.map(value => value),
        configParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        creationDate.map(value => value),
        customDomainCertificateArn.map(value => value),
        customDomainCertificateExpiryTime.map(value => value),
        customDomainName.map(value => value),
        endpoint.map(value => value.asEditable),
        enhancedVpcRouting.map(value => value),
        namespaceName.map(value => value),
        patchVersion.map(value => value),
        port.map(value => value),
        publiclyAccessible.map(value => value),
        securityGroupIds.map(value => value),
        status.map(value => value),
        subnetIds.map(value => value),
        workgroupArn.map(value => value),
        workgroupId.map(value => value),
        workgroupName.map(value => value),
        workgroupVersion.map(value => value)
      )
    def baseCapacity: Optional[Integer]
    def configParameters: Optional[
      List[zio.aws.redshiftserverless.model.ConfigParameter.ReadOnly]
    ]
    def creationDate: Optional[SyntheticTimestamp_date_time]
    def customDomainCertificateArn: Optional[CustomDomainCertificateArnString]
    def customDomainCertificateExpiryTime
        : Optional[SyntheticTimestamp_date_time]
    def customDomainName: Optional[CustomDomainName]
    def endpoint: Optional[zio.aws.redshiftserverless.model.Endpoint.ReadOnly]
    def enhancedVpcRouting: Optional[Boolean]
    def namespaceName: Optional[String]
    def patchVersion: Optional[String]
    def port: Optional[Integer]
    def publiclyAccessible: Optional[Boolean]
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def status: Optional[zio.aws.redshiftserverless.model.WorkgroupStatus]
    def subnetIds: Optional[List[SubnetId]]
    def workgroupArn: Optional[String]
    def workgroupId: Optional[String]
    def workgroupName: Optional[WorkgroupName]
    def workgroupVersion: Optional[String]
    def getBaseCapacity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("baseCapacity", baseCapacity)
    def getConfigParameters: ZIO[Any, AwsError, List[
      zio.aws.redshiftserverless.model.ConfigParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("configParameters", configParameters)
    def getCreationDate: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getCustomDomainCertificateArn
        : ZIO[Any, AwsError, CustomDomainCertificateArnString] =
      AwsError.unwrapOptionField(
        "customDomainCertificateArn",
        customDomainCertificateArn
      )
    def getCustomDomainCertificateExpiryTime
        : ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField(
        "customDomainCertificateExpiryTime",
        customDomainCertificateExpiryTime
      )
    def getCustomDomainName: ZIO[Any, AwsError, CustomDomainName] =
      AwsError.unwrapOptionField("customDomainName", customDomainName)
    def getEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.Endpoint.ReadOnly
    ] = AwsError.unwrapOptionField("endpoint", endpoint)
    def getEnhancedVpcRouting: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enhancedVpcRouting", enhancedVpcRouting)
    def getNamespaceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("namespaceName", namespaceName)
    def getPatchVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("patchVersion", patchVersion)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getPubliclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.redshiftserverless.model.WorkgroupStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getWorkgroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("workgroupArn", workgroupArn)
    def getWorkgroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("workgroupId", workgroupId)
    def getWorkgroupName: ZIO[Any, AwsError, WorkgroupName] =
      AwsError.unwrapOptionField("workgroupName", workgroupName)
    def getWorkgroupVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("workgroupVersion", workgroupVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.Workgroup
  ) extends zio.aws.redshiftserverless.model.Workgroup.ReadOnly {
    override val baseCapacity: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.baseCapacity())
      .map(value => value: Integer)
    override val configParameters: Optional[
      List[zio.aws.redshiftserverless.model.ConfigParameter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.configParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshiftserverless.model.ConfigParameter.wrap(item)
        }.toList
      )
    override val creationDate: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationDate())
        .map(value =>
          zio.aws.redshiftserverless.model.primitives
            .SyntheticTimestamp_date_time(value)
        )
    override val customDomainCertificateArn
        : Optional[CustomDomainCertificateArnString] = zio.aws.core.internal
      .optionalFromNullable(impl.customDomainCertificateArn())
      .map(value =>
        zio.aws.redshiftserverless.model.primitives
          .CustomDomainCertificateArnString(value)
      )
    override val customDomainCertificateExpiryTime
        : Optional[SyntheticTimestamp_date_time] = zio.aws.core.internal
      .optionalFromNullable(impl.customDomainCertificateExpiryTime())
      .map(value =>
        zio.aws.redshiftserverless.model.primitives
          .SyntheticTimestamp_date_time(value)
      )
    override val customDomainName: Optional[CustomDomainName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customDomainName())
        .map(value =>
          zio.aws.redshiftserverless.model.primitives.CustomDomainName(value)
        )
    override val endpoint
        : Optional[zio.aws.redshiftserverless.model.Endpoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpoint())
        .map(value => zio.aws.redshiftserverless.model.Endpoint.wrap(value))
    override val enhancedVpcRouting: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enhancedVpcRouting())
      .map(value => value: Boolean)
    override val namespaceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceName())
      .map(value => value: String)
    override val patchVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.patchVersion())
      .map(value => value: String)
    override val port: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: Integer)
    override val publiclyAccessible: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.publiclyAccessible())
      .map(value => value: Boolean)
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshiftserverless.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val status
        : Optional[zio.aws.redshiftserverless.model.WorkgroupStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.redshiftserverless.model.WorkgroupStatus.wrap(value)
        )
    override val subnetIds: Optional[List[SubnetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshiftserverless.model.primitives.SubnetId(item)
        }.toList
      )
    override val workgroupArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.workgroupArn())
      .map(value => value: String)
    override val workgroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.workgroupId())
      .map(value => value: String)
    override val workgroupName: Optional[WorkgroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.workgroupName())
      .map(value =>
        zio.aws.redshiftserverless.model.primitives.WorkgroupName(value)
      )
    override val workgroupVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.workgroupVersion())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.Workgroup
  ): zio.aws.redshiftserverless.model.Workgroup.ReadOnly = new Wrapper(impl)
}
