package zio.aws.redshiftserverless.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.redshiftserverless.model.primitives.{
  WorkgroupName,
  CustomDomainName,
  SyntheticTimestamp_date_time,
  CustomDomainCertificateArnString
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class UpdateCustomDomainAssociationResponse(
    customDomainCertificateArn: Optional[CustomDomainCertificateArnString] =
      Optional.Absent,
    customDomainCertificateExpiryTime: Optional[SyntheticTimestamp_date_time] =
      Optional.Absent,
    customDomainName: Optional[CustomDomainName] = Optional.Absent,
    workgroupName: Optional[WorkgroupName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.UpdateCustomDomainAssociationResponse = {
    import UpdateCustomDomainAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.UpdateCustomDomainAssociationResponse
      .builder()
      .optionallyWith(
        customDomainCertificateArn.map(value =>
          CustomDomainCertificateArnString.unwrap(value): java.lang.String
        )
      )(_.customDomainCertificateArn)
      .optionallyWith(
        customDomainCertificateExpiryTime.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.customDomainCertificateExpiryTime)
      .optionallyWith(
        customDomainName.map(value =>
          CustomDomainName.unwrap(value): java.lang.String
        )
      )(_.customDomainName)
      .optionallyWith(
        workgroupName.map(value =>
          WorkgroupName.unwrap(value): java.lang.String
        )
      )(_.workgroupName)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.UpdateCustomDomainAssociationResponse.ReadOnly =
    zio.aws.redshiftserverless.model.UpdateCustomDomainAssociationResponse
      .wrap(buildAwsValue())
}
object UpdateCustomDomainAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.UpdateCustomDomainAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshiftserverless.model.UpdateCustomDomainAssociationResponse =
      zio.aws.redshiftserverless.model.UpdateCustomDomainAssociationResponse(
        customDomainCertificateArn.map(value => value),
        customDomainCertificateExpiryTime.map(value => value),
        customDomainName.map(value => value),
        workgroupName.map(value => value)
      )
    def customDomainCertificateArn: Optional[CustomDomainCertificateArnString]
    def customDomainCertificateExpiryTime
        : Optional[SyntheticTimestamp_date_time]
    def customDomainName: Optional[CustomDomainName]
    def workgroupName: Optional[WorkgroupName]
    def getCustomDomainCertificateArn
        : ZIO[Any, AwsError, CustomDomainCertificateArnString] =
      AwsError.unwrapOptionField(
        "customDomainCertificateArn",
        customDomainCertificateArn
      )
    def getCustomDomainCertificateExpiryTime
        : ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField(
        "customDomainCertificateExpiryTime",
        customDomainCertificateExpiryTime
      )
    def getCustomDomainName: ZIO[Any, AwsError, CustomDomainName] =
      AwsError.unwrapOptionField("customDomainName", customDomainName)
    def getWorkgroupName: ZIO[Any, AwsError, WorkgroupName] =
      AwsError.unwrapOptionField("workgroupName", workgroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.UpdateCustomDomainAssociationResponse
  ) extends zio.aws.redshiftserverless.model.UpdateCustomDomainAssociationResponse.ReadOnly {
    override val customDomainCertificateArn
        : Optional[CustomDomainCertificateArnString] = zio.aws.core.internal
      .optionalFromNullable(impl.customDomainCertificateArn())
      .map(value =>
        zio.aws.redshiftserverless.model.primitives
          .CustomDomainCertificateArnString(value)
      )
    override val customDomainCertificateExpiryTime
        : Optional[SyntheticTimestamp_date_time] = zio.aws.core.internal
      .optionalFromNullable(impl.customDomainCertificateExpiryTime())
      .map(value =>
        zio.aws.redshiftserverless.model.primitives
          .SyntheticTimestamp_date_time(value)
      )
    override val customDomainName: Optional[CustomDomainName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customDomainName())
        .map(value =>
          zio.aws.redshiftserverless.model.primitives.CustomDomainName(value)
        )
    override val workgroupName: Optional[WorkgroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.workgroupName())
      .map(value =>
        zio.aws.redshiftserverless.model.primitives.WorkgroupName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.UpdateCustomDomainAssociationResponse
  ): zio.aws.redshiftserverless.model.UpdateCustomDomainAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
