package zio.aws.redshiftserverless.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.redshiftserverless.model.primitives.{
  Integer,
  SyntheticTimestamp_date_time,
  KmsKeyId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Snapshot(
    accountsWithProvisionedRestoreAccess: Optional[Iterable[String]] =
      Optional.Absent,
    accountsWithRestoreAccess: Optional[Iterable[String]] = Optional.Absent,
    actualIncrementalBackupSizeInMegaBytes: Optional[Double] = Optional.Absent,
    adminPasswordSecretArn: Optional[String] = Optional.Absent,
    adminPasswordSecretKmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    adminUsername: Optional[String] = Optional.Absent,
    backupProgressInMegaBytes: Optional[Double] = Optional.Absent,
    currentBackupRateInMegaBytesPerSecond: Optional[Double] = Optional.Absent,
    elapsedTimeInSeconds: Optional[Long] = Optional.Absent,
    estimatedSecondsToCompletion: Optional[Long] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    namespaceArn: Optional[String] = Optional.Absent,
    namespaceName: Optional[String] = Optional.Absent,
    ownerAccount: Optional[String] = Optional.Absent,
    snapshotArn: Optional[String] = Optional.Absent,
    snapshotCreateTime: Optional[SyntheticTimestamp_date_time] =
      Optional.Absent,
    snapshotName: Optional[String] = Optional.Absent,
    snapshotRemainingDays: Optional[Integer] = Optional.Absent,
    snapshotRetentionPeriod: Optional[Integer] = Optional.Absent,
    snapshotRetentionStartTime: Optional[SyntheticTimestamp_date_time] =
      Optional.Absent,
    status: Optional[zio.aws.redshiftserverless.model.SnapshotStatus] =
      Optional.Absent,
    totalBackupSizeInMegaBytes: Optional[Double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.Snapshot = {
    import Snapshot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.Snapshot
      .builder()
      .optionallyWith(
        accountsWithProvisionedRestoreAccess.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.accountsWithProvisionedRestoreAccess)
      .optionallyWith(
        accountsWithRestoreAccess.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.accountsWithRestoreAccess)
      .optionallyWith(
        actualIncrementalBackupSizeInMegaBytes.map(value =>
          value: java.lang.Double
        )
      )(_.actualIncrementalBackupSizeInMegaBytes)
      .optionallyWith(
        adminPasswordSecretArn.map(value => value: java.lang.String)
      )(_.adminPasswordSecretArn)
      .optionallyWith(
        adminPasswordSecretKmsKeyId.map(value =>
          KmsKeyId.unwrap(value): java.lang.String
        )
      )(_.adminPasswordSecretKmsKeyId)
      .optionallyWith(adminUsername.map(value => value: java.lang.String))(
        _.adminUsername
      )
      .optionallyWith(
        backupProgressInMegaBytes.map(value => value: java.lang.Double)
      )(_.backupProgressInMegaBytes)
      .optionallyWith(
        currentBackupRateInMegaBytesPerSecond.map(value =>
          value: java.lang.Double
        )
      )(_.currentBackupRateInMegaBytesPerSecond)
      .optionallyWith(elapsedTimeInSeconds.map(value => value: java.lang.Long))(
        _.elapsedTimeInSeconds
      )
      .optionallyWith(
        estimatedSecondsToCompletion.map(value => value: java.lang.Long)
      )(_.estimatedSecondsToCompletion)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(namespaceArn.map(value => value: java.lang.String))(
        _.namespaceArn
      )
      .optionallyWith(namespaceName.map(value => value: java.lang.String))(
        _.namespaceName
      )
      .optionallyWith(ownerAccount.map(value => value: java.lang.String))(
        _.ownerAccount
      )
      .optionallyWith(snapshotArn.map(value => value: java.lang.String))(
        _.snapshotArn
      )
      .optionallyWith(
        snapshotCreateTime.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.snapshotCreateTime)
      .optionallyWith(snapshotName.map(value => value: java.lang.String))(
        _.snapshotName
      )
      .optionallyWith(
        snapshotRemainingDays.map(value => value: java.lang.Integer)
      )(_.snapshotRemainingDays)
      .optionallyWith(
        snapshotRetentionPeriod.map(value => value: java.lang.Integer)
      )(_.snapshotRetentionPeriod)
      .optionallyWith(
        snapshotRetentionStartTime.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.snapshotRetentionStartTime)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        totalBackupSizeInMegaBytes.map(value => value: java.lang.Double)
      )(_.totalBackupSizeInMegaBytes)
      .build()
  }
  def asReadOnly: zio.aws.redshiftserverless.model.Snapshot.ReadOnly =
    zio.aws.redshiftserverless.model.Snapshot.wrap(buildAwsValue())
}
object Snapshot {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.Snapshot
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.Snapshot =
      zio.aws.redshiftserverless.model.Snapshot(
        accountsWithProvisionedRestoreAccess.map(value => value),
        accountsWithRestoreAccess.map(value => value),
        actualIncrementalBackupSizeInMegaBytes.map(value => value),
        adminPasswordSecretArn.map(value => value),
        adminPasswordSecretKmsKeyId.map(value => value),
        adminUsername.map(value => value),
        backupProgressInMegaBytes.map(value => value),
        currentBackupRateInMegaBytesPerSecond.map(value => value),
        elapsedTimeInSeconds.map(value => value),
        estimatedSecondsToCompletion.map(value => value),
        kmsKeyId.map(value => value),
        namespaceArn.map(value => value),
        namespaceName.map(value => value),
        ownerAccount.map(value => value),
        snapshotArn.map(value => value),
        snapshotCreateTime.map(value => value),
        snapshotName.map(value => value),
        snapshotRemainingDays.map(value => value),
        snapshotRetentionPeriod.map(value => value),
        snapshotRetentionStartTime.map(value => value),
        status.map(value => value),
        totalBackupSizeInMegaBytes.map(value => value)
      )
    def accountsWithProvisionedRestoreAccess: Optional[List[String]]
    def accountsWithRestoreAccess: Optional[List[String]]
    def actualIncrementalBackupSizeInMegaBytes: Optional[Double]
    def adminPasswordSecretArn: Optional[String]
    def adminPasswordSecretKmsKeyId: Optional[KmsKeyId]
    def adminUsername: Optional[String]
    def backupProgressInMegaBytes: Optional[Double]
    def currentBackupRateInMegaBytesPerSecond: Optional[Double]
    def elapsedTimeInSeconds: Optional[Long]
    def estimatedSecondsToCompletion: Optional[Long]
    def kmsKeyId: Optional[KmsKeyId]
    def namespaceArn: Optional[String]
    def namespaceName: Optional[String]
    def ownerAccount: Optional[String]
    def snapshotArn: Optional[String]
    def snapshotCreateTime: Optional[SyntheticTimestamp_date_time]
    def snapshotName: Optional[String]
    def snapshotRemainingDays: Optional[Integer]
    def snapshotRetentionPeriod: Optional[Integer]
    def snapshotRetentionStartTime: Optional[SyntheticTimestamp_date_time]
    def status: Optional[zio.aws.redshiftserverless.model.SnapshotStatus]
    def totalBackupSizeInMegaBytes: Optional[Double]
    def getAccountsWithProvisionedRestoreAccess
        : ZIO[Any, AwsError, List[String]] = AwsError.unwrapOptionField(
      "accountsWithProvisionedRestoreAccess",
      accountsWithProvisionedRestoreAccess
    )
    def getAccountsWithRestoreAccess: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "accountsWithRestoreAccess",
        accountsWithRestoreAccess
      )
    def getActualIncrementalBackupSizeInMegaBytes: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField(
        "actualIncrementalBackupSizeInMegaBytes",
        actualIncrementalBackupSizeInMegaBytes
      )
    def getAdminPasswordSecretArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("adminPasswordSecretArn", adminPasswordSecretArn)
    def getAdminPasswordSecretKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField(
        "adminPasswordSecretKmsKeyId",
        adminPasswordSecretKmsKeyId
      )
    def getAdminUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("adminUsername", adminUsername)
    def getBackupProgressInMegaBytes: ZIO[Any, AwsError, Double] = AwsError
      .unwrapOptionField("backupProgressInMegaBytes", backupProgressInMegaBytes)
    def getCurrentBackupRateInMegaBytesPerSecond: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField(
        "currentBackupRateInMegaBytesPerSecond",
        currentBackupRateInMegaBytesPerSecond
      )
    def getElapsedTimeInSeconds: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("elapsedTimeInSeconds", elapsedTimeInSeconds)
    def getEstimatedSecondsToCompletion: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "estimatedSecondsToCompletion",
        estimatedSecondsToCompletion
      )
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getNamespaceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("namespaceArn", namespaceArn)
    def getNamespaceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("namespaceName", namespaceName)
    def getOwnerAccount: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerAccount", ownerAccount)
    def getSnapshotArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotArn", snapshotArn)
    def getSnapshotCreateTime
        : ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("snapshotCreateTime", snapshotCreateTime)
    def getSnapshotName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotName", snapshotName)
    def getSnapshotRemainingDays: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("snapshotRemainingDays", snapshotRemainingDays)
    def getSnapshotRetentionPeriod: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("snapshotRetentionPeriod", snapshotRetentionPeriod)
    def getSnapshotRetentionStartTime
        : ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField(
        "snapshotRetentionStartTime",
        snapshotRetentionStartTime
      )
    def getStatus
        : ZIO[Any, AwsError, zio.aws.redshiftserverless.model.SnapshotStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTotalBackupSizeInMegaBytes: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField(
        "totalBackupSizeInMegaBytes",
        totalBackupSizeInMegaBytes
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.Snapshot
  ) extends zio.aws.redshiftserverless.model.Snapshot.ReadOnly {
    override val accountsWithProvisionedRestoreAccess: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountsWithProvisionedRestoreAccess())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val accountsWithRestoreAccess: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountsWithRestoreAccess())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val actualIncrementalBackupSizeInMegaBytes: Optional[Double] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actualIncrementalBackupSizeInMegaBytes())
        .map(value => value: Double)
    override val adminPasswordSecretArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adminPasswordSecretArn())
        .map(value => value: String)
    override val adminPasswordSecretKmsKeyId: Optional[KmsKeyId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adminPasswordSecretKmsKeyId())
        .map(value =>
          zio.aws.redshiftserverless.model.primitives.KmsKeyId(value)
        )
    override val adminUsername: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.adminUsername())
      .map(value => value: String)
    override val backupProgressInMegaBytes: Optional[Double] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupProgressInMegaBytes())
        .map(value => value: Double)
    override val currentBackupRateInMegaBytesPerSecond: Optional[Double] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentBackupRateInMegaBytesPerSecond())
        .map(value => value: Double)
    override val elapsedTimeInSeconds: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.elapsedTimeInSeconds())
      .map(value => value: Long)
    override val estimatedSecondsToCompletion: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.estimatedSecondsToCompletion())
        .map(value => value: Long)
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.redshiftserverless.model.primitives.KmsKeyId(value))
    override val namespaceArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceArn())
      .map(value => value: String)
    override val namespaceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceName())
      .map(value => value: String)
    override val ownerAccount: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerAccount())
      .map(value => value: String)
    override val snapshotArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotArn())
      .map(value => value: String)
    override val snapshotCreateTime: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotCreateTime())
        .map(value =>
          zio.aws.redshiftserverless.model.primitives
            .SyntheticTimestamp_date_time(value)
        )
    override val snapshotName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotName())
      .map(value => value: String)
    override val snapshotRemainingDays: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotRemainingDays())
        .map(value => value: Integer)
    override val snapshotRetentionPeriod: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotRetentionPeriod())
        .map(value => value: Integer)
    override val snapshotRetentionStartTime
        : Optional[SyntheticTimestamp_date_time] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotRetentionStartTime())
      .map(value =>
        zio.aws.redshiftserverless.model.primitives
          .SyntheticTimestamp_date_time(value)
      )
    override val status
        : Optional[zio.aws.redshiftserverless.model.SnapshotStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.redshiftserverless.model.SnapshotStatus.wrap(value)
        )
    override val totalBackupSizeInMegaBytes: Optional[Double] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalBackupSizeInMegaBytes())
        .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.Snapshot
  ): zio.aws.redshiftserverless.model.Snapshot.ReadOnly = new Wrapper(impl)
}
