package zio.aws.redshiftserverless.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.redshiftserverless.model.primitives.{
  WorkgroupName,
  SyntheticTimestamp_date_time,
  NamespaceName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class RecoveryPoint(
    namespaceArn: Optional[String] = Optional.Absent,
    namespaceName: Optional[NamespaceName] = Optional.Absent,
    recoveryPointCreateTime: Optional[SyntheticTimestamp_date_time] =
      Optional.Absent,
    recoveryPointId: Optional[String] = Optional.Absent,
    totalSizeInMegaBytes: Optional[Double] = Optional.Absent,
    workgroupName: Optional[WorkgroupName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.RecoveryPoint = {
    import RecoveryPoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.RecoveryPoint
      .builder()
      .optionallyWith(namespaceArn.map(value => value: java.lang.String))(
        _.namespaceArn
      )
      .optionallyWith(
        namespaceName.map(value =>
          NamespaceName.unwrap(value): java.lang.String
        )
      )(_.namespaceName)
      .optionallyWith(
        recoveryPointCreateTime.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.recoveryPointCreateTime)
      .optionallyWith(recoveryPointId.map(value => value: java.lang.String))(
        _.recoveryPointId
      )
      .optionallyWith(
        totalSizeInMegaBytes.map(value => value: java.lang.Double)
      )(_.totalSizeInMegaBytes)
      .optionallyWith(
        workgroupName.map(value =>
          WorkgroupName.unwrap(value): java.lang.String
        )
      )(_.workgroupName)
      .build()
  }
  def asReadOnly: zio.aws.redshiftserverless.model.RecoveryPoint.ReadOnly =
    zio.aws.redshiftserverless.model.RecoveryPoint.wrap(buildAwsValue())
}
object RecoveryPoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.RecoveryPoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.RecoveryPoint =
      zio.aws.redshiftserverless.model.RecoveryPoint(
        namespaceArn.map(value => value),
        namespaceName.map(value => value),
        recoveryPointCreateTime.map(value => value),
        recoveryPointId.map(value => value),
        totalSizeInMegaBytes.map(value => value),
        workgroupName.map(value => value)
      )
    def namespaceArn: Optional[String]
    def namespaceName: Optional[NamespaceName]
    def recoveryPointCreateTime: Optional[SyntheticTimestamp_date_time]
    def recoveryPointId: Optional[String]
    def totalSizeInMegaBytes: Optional[Double]
    def workgroupName: Optional[WorkgroupName]
    def getNamespaceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("namespaceArn", namespaceArn)
    def getNamespaceName: ZIO[Any, AwsError, NamespaceName] =
      AwsError.unwrapOptionField("namespaceName", namespaceName)
    def getRecoveryPointCreateTime
        : ZIO[Any, AwsError, SyntheticTimestamp_date_time] = AwsError
      .unwrapOptionField("recoveryPointCreateTime", recoveryPointCreateTime)
    def getRecoveryPointId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("recoveryPointId", recoveryPointId)
    def getTotalSizeInMegaBytes: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("totalSizeInMegaBytes", totalSizeInMegaBytes)
    def getWorkgroupName: ZIO[Any, AwsError, WorkgroupName] =
      AwsError.unwrapOptionField("workgroupName", workgroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.RecoveryPoint
  ) extends zio.aws.redshiftserverless.model.RecoveryPoint.ReadOnly {
    override val namespaceArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceArn())
      .map(value => value: String)
    override val namespaceName: Optional[NamespaceName] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceName())
      .map(value =>
        zio.aws.redshiftserverless.model.primitives.NamespaceName(value)
      )
    override val recoveryPointCreateTime
        : Optional[SyntheticTimestamp_date_time] = zio.aws.core.internal
      .optionalFromNullable(impl.recoveryPointCreateTime())
      .map(value =>
        zio.aws.redshiftserverless.model.primitives
          .SyntheticTimestamp_date_time(value)
      )
    override val recoveryPointId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.recoveryPointId())
      .map(value => value: String)
    override val totalSizeInMegaBytes: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.totalSizeInMegaBytes())
      .map(value => value: Double)
    override val workgroupName: Optional[WorkgroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.workgroupName())
      .map(value =>
        zio.aws.redshiftserverless.model.primitives.WorkgroupName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.RecoveryPoint
  ): zio.aws.redshiftserverless.model.RecoveryPoint.ReadOnly = new Wrapper(impl)
}
