package zio.aws.redshiftserverless.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.redshiftserverless.model.primitives.{
  NamespaceName,
  ListRecoveryPointsRequestMaxResultsInteger,
  Timestamp
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListRecoveryPointsRequest(
    endTime: Optional[Timestamp] = Optional.Absent,
    maxResults: Optional[ListRecoveryPointsRequestMaxResultsInteger] =
      Optional.Absent,
    namespaceArn: Optional[String] = Optional.Absent,
    namespaceName: Optional[NamespaceName] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsRequest = {
    import ListRecoveryPointsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsRequest
      .builder()
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        maxResults.map(value =>
          ListRecoveryPointsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(namespaceArn.map(value => value: java.lang.String))(
        _.namespaceArn
      )
      .optionallyWith(
        namespaceName.map(value =>
          NamespaceName.unwrap(value): java.lang.String
        )
      )(_.namespaceName)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.ListRecoveryPointsRequest.ReadOnly =
    zio.aws.redshiftserverless.model.ListRecoveryPointsRequest
      .wrap(buildAwsValue())
}
object ListRecoveryPointsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.ListRecoveryPointsRequest =
      zio.aws.redshiftserverless.model.ListRecoveryPointsRequest(
        endTime.map(value => value),
        maxResults.map(value => value),
        namespaceArn.map(value => value),
        namespaceName.map(value => value),
        nextToken.map(value => value),
        startTime.map(value => value)
      )
    def endTime: Optional[Timestamp]
    def maxResults: Optional[ListRecoveryPointsRequestMaxResultsInteger]
    def namespaceArn: Optional[String]
    def namespaceName: Optional[NamespaceName]
    def nextToken: Optional[String]
    def startTime: Optional[Timestamp]
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getMaxResults
        : ZIO[Any, AwsError, ListRecoveryPointsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNamespaceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("namespaceArn", namespaceArn)
    def getNamespaceName: ZIO[Any, AwsError, NamespaceName] =
      AwsError.unwrapOptionField("namespaceName", namespaceName)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsRequest
  ) extends zio.aws.redshiftserverless.model.ListRecoveryPointsRequest.ReadOnly {
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value =>
        zio.aws.redshiftserverless.model.primitives.Timestamp(value)
      )
    override val maxResults
        : Optional[ListRecoveryPointsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.redshiftserverless.model.primitives
            .ListRecoveryPointsRequestMaxResultsInteger(value)
        )
    override val namespaceArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceArn())
      .map(value => value: String)
    override val namespaceName: Optional[NamespaceName] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceName())
      .map(value =>
        zio.aws.redshiftserverless.model.primitives.NamespaceName(value)
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value =>
        zio.aws.redshiftserverless.model.primitives.Timestamp(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListRecoveryPointsRequest
  ): zio.aws.redshiftserverless.model.ListRecoveryPointsRequest.ReadOnly =
    new Wrapper(impl)
}
