package zio.aws.redshiftserverless.model
import zio.prelude.data.Optional
import zio.aws.redshiftserverless.model.primitives.ListEndpointAccessRequestMaxResultsInteger
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListEndpointAccessRequest(
    maxResults: Optional[ListEndpointAccessRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    workgroupName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessRequest = {
    import ListEndpointAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListEndpointAccessRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(workgroupName.map(value => value: java.lang.String))(
        _.workgroupName
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.ListEndpointAccessRequest.ReadOnly =
    zio.aws.redshiftserverless.model.ListEndpointAccessRequest
      .wrap(buildAwsValue())
}
object ListEndpointAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.ListEndpointAccessRequest =
      zio.aws.redshiftserverless.model.ListEndpointAccessRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        vpcId.map(value => value),
        workgroupName.map(value => value)
      )
    def maxResults: Optional[ListEndpointAccessRequestMaxResultsInteger]
    def nextToken: Optional[String]
    def vpcId: Optional[String]
    def workgroupName: Optional[String]
    def getMaxResults
        : ZIO[Any, AwsError, ListEndpointAccessRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getWorkgroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("workgroupName", workgroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessRequest
  ) extends zio.aws.redshiftserverless.model.ListEndpointAccessRequest.ReadOnly {
    override val maxResults
        : Optional[ListEndpointAccessRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.redshiftserverless.model.primitives
            .ListEndpointAccessRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val workgroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.workgroupName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessRequest
  ): zio.aws.redshiftserverless.model.ListEndpointAccessRequest.ReadOnly =
    new Wrapper(impl)
}
