package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.redshiftserverless.model.primitives.PaginationToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListCustomDomainAssociationsResponse(
    associations: Optional[
      Iterable[zio.aws.redshiftserverless.model.Association]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsResponse = {
    import ListCustomDomainAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsResponse
      .builder()
      .optionallyWith(
        associations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associations)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.ListCustomDomainAssociationsResponse.ReadOnly =
    zio.aws.redshiftserverless.model.ListCustomDomainAssociationsResponse
      .wrap(buildAwsValue())
}
object ListCustomDomainAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshiftserverless.model.ListCustomDomainAssociationsResponse =
      zio.aws.redshiftserverless.model.ListCustomDomainAssociationsResponse(
        associations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def associations
        : Optional[List[zio.aws.redshiftserverless.model.Association.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getAssociations: ZIO[Any, AwsError, List[
      zio.aws.redshiftserverless.model.Association.ReadOnly
    ]] = AwsError.unwrapOptionField("associations", associations)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsResponse
  ) extends zio.aws.redshiftserverless.model.ListCustomDomainAssociationsResponse.ReadOnly {
    override val associations: Optional[
      List[zio.aws.redshiftserverless.model.Association.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.associations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshiftserverless.model.Association.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.redshiftserverless.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsResponse
  ): zio.aws.redshiftserverless.model.ListCustomDomainAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
