package zio.aws.redshiftserverless.model
import zio.prelude.data.Optional
import zio.aws.redshiftserverless.model.primitives.{
  PaginationToken,
  ListCustomDomainAssociationsRequestMaxResultsInteger,
  CustomDomainName,
  CustomDomainCertificateArnString
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListCustomDomainAssociationsRequest(
    customDomainCertificateArn: Optional[CustomDomainCertificateArnString] =
      Optional.Absent,
    customDomainName: Optional[CustomDomainName] = Optional.Absent,
    maxResults: Optional[ListCustomDomainAssociationsRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsRequest = {
    import ListCustomDomainAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsRequest
      .builder()
      .optionallyWith(
        customDomainCertificateArn.map(value =>
          CustomDomainCertificateArnString.unwrap(value): java.lang.String
        )
      )(_.customDomainCertificateArn)
      .optionallyWith(
        customDomainName.map(value =>
          CustomDomainName.unwrap(value): java.lang.String
        )
      )(_.customDomainName)
      .optionallyWith(
        maxResults.map(value =>
          ListCustomDomainAssociationsRequestMaxResultsInteger.unwrap(
            value
          ): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.ListCustomDomainAssociationsRequest.ReadOnly =
    zio.aws.redshiftserverless.model.ListCustomDomainAssociationsRequest
      .wrap(buildAwsValue())
}
object ListCustomDomainAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshiftserverless.model.ListCustomDomainAssociationsRequest =
      zio.aws.redshiftserverless.model.ListCustomDomainAssociationsRequest(
        customDomainCertificateArn.map(value => value),
        customDomainName.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def customDomainCertificateArn: Optional[CustomDomainCertificateArnString]
    def customDomainName: Optional[CustomDomainName]
    def maxResults
        : Optional[ListCustomDomainAssociationsRequestMaxResultsInteger]
    def nextToken: Optional[PaginationToken]
    def getCustomDomainCertificateArn
        : ZIO[Any, AwsError, CustomDomainCertificateArnString] =
      AwsError.unwrapOptionField(
        "customDomainCertificateArn",
        customDomainCertificateArn
      )
    def getCustomDomainName: ZIO[Any, AwsError, CustomDomainName] =
      AwsError.unwrapOptionField("customDomainName", customDomainName)
    def getMaxResults: ZIO[
      Any,
      AwsError,
      ListCustomDomainAssociationsRequestMaxResultsInteger
    ] = AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsRequest
  ) extends zio.aws.redshiftserverless.model.ListCustomDomainAssociationsRequest.ReadOnly {
    override val customDomainCertificateArn
        : Optional[CustomDomainCertificateArnString] = zio.aws.core.internal
      .optionalFromNullable(impl.customDomainCertificateArn())
      .map(value =>
        zio.aws.redshiftserverless.model.primitives
          .CustomDomainCertificateArnString(value)
      )
    override val customDomainName: Optional[CustomDomainName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customDomainName())
        .map(value =>
          zio.aws.redshiftserverless.model.primitives.CustomDomainName(value)
        )
    override val maxResults
        : Optional[ListCustomDomainAssociationsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.redshiftserverless.model.primitives
            .ListCustomDomainAssociationsRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.redshiftserverless.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListCustomDomainAssociationsRequest
  ): zio.aws.redshiftserverless.model.ListCustomDomainAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
