package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.redshiftserverless.model.primitives.{
  WorkgroupName,
  CustomDomainName
}
import scala.jdk.CollectionConverters._
final case class GetCustomDomainAssociationRequest(
    customDomainName: CustomDomainName,
    workgroupName: WorkgroupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.GetCustomDomainAssociationRequest = {
    import GetCustomDomainAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.GetCustomDomainAssociationRequest
      .builder()
      .customDomainName(
        CustomDomainName.unwrap(customDomainName): java.lang.String
      )
      .workgroupName(WorkgroupName.unwrap(workgroupName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.GetCustomDomainAssociationRequest.ReadOnly =
    zio.aws.redshiftserverless.model.GetCustomDomainAssociationRequest
      .wrap(buildAwsValue())
}
object GetCustomDomainAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.GetCustomDomainAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshiftserverless.model.GetCustomDomainAssociationRequest =
      zio.aws.redshiftserverless.model
        .GetCustomDomainAssociationRequest(customDomainName, workgroupName)
    def customDomainName: CustomDomainName
    def workgroupName: WorkgroupName
    def getCustomDomainName: ZIO[Any, Nothing, CustomDomainName] =
      ZIO.succeed(customDomainName)
    def getWorkgroupName: ZIO[Any, Nothing, WorkgroupName] =
      ZIO.succeed(workgroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.GetCustomDomainAssociationRequest
  ) extends zio.aws.redshiftserverless.model.GetCustomDomainAssociationRequest.ReadOnly {
    override val customDomainName: CustomDomainName =
      zio.aws.redshiftserverless.model.primitives
        .CustomDomainName(impl.customDomainName())
    override val workgroupName: WorkgroupName =
      zio.aws.redshiftserverless.model.primitives
        .WorkgroupName(impl.workgroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.GetCustomDomainAssociationRequest
  ): zio.aws.redshiftserverless.model.GetCustomDomainAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
