package zio.aws.redshiftserverless.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.redshiftserverless.model.primitives.{
  Timestamp,
  DbUser,
  DbPassword
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetCredentialsResponse(
    dbPassword: Optional[DbPassword] = Optional.Absent,
    dbUser: Optional[DbUser] = Optional.Absent,
    expiration: Optional[Timestamp] = Optional.Absent,
    nextRefreshTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.GetCredentialsResponse = {
    import GetCredentialsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.GetCredentialsResponse
      .builder()
      .optionallyWith(
        dbPassword.map(value => DbPassword.unwrap(value): java.lang.String)
      )(_.dbPassword)
      .optionallyWith(
        dbUser.map(value => DbUser.unwrap(value): java.lang.String)
      )(_.dbUser)
      .optionallyWith(
        expiration.map(value => Timestamp.unwrap(value): Instant)
      )(_.expiration)
      .optionallyWith(
        nextRefreshTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.nextRefreshTime)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.GetCredentialsResponse.ReadOnly =
    zio.aws.redshiftserverless.model.GetCredentialsResponse
      .wrap(buildAwsValue())
}
object GetCredentialsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.GetCredentialsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.GetCredentialsResponse =
      zio.aws.redshiftserverless.model.GetCredentialsResponse(
        dbPassword.map(value => value),
        dbUser.map(value => value),
        expiration.map(value => value),
        nextRefreshTime.map(value => value)
      )
    def dbPassword: Optional[DbPassword]
    def dbUser: Optional[DbUser]
    def expiration: Optional[Timestamp]
    def nextRefreshTime: Optional[Timestamp]
    def getDbPassword: ZIO[Any, AwsError, DbPassword] =
      AwsError.unwrapOptionField("dbPassword", dbPassword)
    def getDbUser: ZIO[Any, AwsError, DbUser] =
      AwsError.unwrapOptionField("dbUser", dbUser)
    def getExpiration: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expiration", expiration)
    def getNextRefreshTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("nextRefreshTime", nextRefreshTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.GetCredentialsResponse
  ) extends zio.aws.redshiftserverless.model.GetCredentialsResponse.ReadOnly {
    override val dbPassword: Optional[DbPassword] = zio.aws.core.internal
      .optionalFromNullable(impl.dbPassword())
      .map(value =>
        zio.aws.redshiftserverless.model.primitives.DbPassword(value)
      )
    override val dbUser: Optional[DbUser] = zio.aws.core.internal
      .optionalFromNullable(impl.dbUser())
      .map(value => zio.aws.redshiftserverless.model.primitives.DbUser(value))
    override val expiration: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.expiration())
      .map(value =>
        zio.aws.redshiftserverless.model.primitives.Timestamp(value)
      )
    override val nextRefreshTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.nextRefreshTime())
      .map(value =>
        zio.aws.redshiftserverless.model.primitives.Timestamp(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.GetCredentialsResponse
  ): zio.aws.redshiftserverless.model.GetCredentialsResponse.ReadOnly =
    new Wrapper(impl)
}
