package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.redshiftserverless.model.primitives.{
  WorkgroupName,
  Integer,
  DbName,
  CustomDomainName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetCredentialsRequest(
    customDomainName: Optional[CustomDomainName] = Optional.Absent,
    dbName: Optional[DbName] = Optional.Absent,
    durationSeconds: Optional[Integer] = Optional.Absent,
    workgroupName: Optional[WorkgroupName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.GetCredentialsRequest = {
    import GetCredentialsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.GetCredentialsRequest
      .builder()
      .optionallyWith(
        customDomainName.map(value =>
          CustomDomainName.unwrap(value): java.lang.String
        )
      )(_.customDomainName)
      .optionallyWith(
        dbName.map(value => DbName.unwrap(value): java.lang.String)
      )(_.dbName)
      .optionallyWith(durationSeconds.map(value => value: java.lang.Integer))(
        _.durationSeconds
      )
      .optionallyWith(
        workgroupName.map(value =>
          WorkgroupName.unwrap(value): java.lang.String
        )
      )(_.workgroupName)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.GetCredentialsRequest.ReadOnly =
    zio.aws.redshiftserverless.model.GetCredentialsRequest.wrap(buildAwsValue())
}
object GetCredentialsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.GetCredentialsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.GetCredentialsRequest =
      zio.aws.redshiftserverless.model.GetCredentialsRequest(
        customDomainName.map(value => value),
        dbName.map(value => value),
        durationSeconds.map(value => value),
        workgroupName.map(value => value)
      )
    def customDomainName: Optional[CustomDomainName]
    def dbName: Optional[DbName]
    def durationSeconds: Optional[Integer]
    def workgroupName: Optional[WorkgroupName]
    def getCustomDomainName: ZIO[Any, AwsError, CustomDomainName] =
      AwsError.unwrapOptionField("customDomainName", customDomainName)
    def getDbName: ZIO[Any, AwsError, DbName] =
      AwsError.unwrapOptionField("dbName", dbName)
    def getDurationSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("durationSeconds", durationSeconds)
    def getWorkgroupName: ZIO[Any, AwsError, WorkgroupName] =
      AwsError.unwrapOptionField("workgroupName", workgroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.GetCredentialsRequest
  ) extends zio.aws.redshiftserverless.model.GetCredentialsRequest.ReadOnly {
    override val customDomainName: Optional[CustomDomainName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customDomainName())
        .map(value =>
          zio.aws.redshiftserverless.model.primitives.CustomDomainName(value)
        )
    override val dbName: Optional[DbName] = zio.aws.core.internal
      .optionalFromNullable(impl.dbName())
      .map(value => zio.aws.redshiftserverless.model.primitives.DbName(value))
    override val durationSeconds: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.durationSeconds())
      .map(value => value: Integer)
    override val workgroupName: Optional[WorkgroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.workgroupName())
      .map(value =>
        zio.aws.redshiftserverless.model.primitives.WorkgroupName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.GetCredentialsRequest
  ): zio.aws.redshiftserverless.model.GetCredentialsRequest.ReadOnly =
    new Wrapper(impl)
}
