package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteWorkgroupResponse(
    workgroup: zio.aws.redshiftserverless.model.Workgroup
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.DeleteWorkgroupResponse = {
    import DeleteWorkgroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.DeleteWorkgroupResponse
      .builder()
      .workgroup(workgroup.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.DeleteWorkgroupResponse.ReadOnly =
    zio.aws.redshiftserverless.model.DeleteWorkgroupResponse
      .wrap(buildAwsValue())
}
object DeleteWorkgroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.DeleteWorkgroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.DeleteWorkgroupResponse =
      zio.aws.redshiftserverless.model
        .DeleteWorkgroupResponse(workgroup.asEditable)
    def workgroup: zio.aws.redshiftserverless.model.Workgroup.ReadOnly
    def getWorkgroup: ZIO[
      Any,
      Nothing,
      zio.aws.redshiftserverless.model.Workgroup.ReadOnly
    ] = ZIO.succeed(workgroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.DeleteWorkgroupResponse
  ) extends zio.aws.redshiftserverless.model.DeleteWorkgroupResponse.ReadOnly {
    override val workgroup
        : zio.aws.redshiftserverless.model.Workgroup.ReadOnly =
      zio.aws.redshiftserverless.model.Workgroup.wrap(impl.workgroup())
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.DeleteWorkgroupResponse
  ): zio.aws.redshiftserverless.model.DeleteWorkgroupResponse.ReadOnly =
    new Wrapper(impl)
}
