package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.redshiftserverless.model.primitives.{
  WorkgroupName,
  CustomDomainName
}
import scala.jdk.CollectionConverters._
final case class DeleteCustomDomainAssociationRequest(
    customDomainName: CustomDomainName,
    workgroupName: WorkgroupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.DeleteCustomDomainAssociationRequest = {
    import DeleteCustomDomainAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.DeleteCustomDomainAssociationRequest
      .builder()
      .customDomainName(
        CustomDomainName.unwrap(customDomainName): java.lang.String
      )
      .workgroupName(WorkgroupName.unwrap(workgroupName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.DeleteCustomDomainAssociationRequest.ReadOnly =
    zio.aws.redshiftserverless.model.DeleteCustomDomainAssociationRequest
      .wrap(buildAwsValue())
}
object DeleteCustomDomainAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.DeleteCustomDomainAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshiftserverless.model.DeleteCustomDomainAssociationRequest =
      zio.aws.redshiftserverless.model
        .DeleteCustomDomainAssociationRequest(customDomainName, workgroupName)
    def customDomainName: CustomDomainName
    def workgroupName: WorkgroupName
    def getCustomDomainName: ZIO[Any, Nothing, CustomDomainName] =
      ZIO.succeed(customDomainName)
    def getWorkgroupName: ZIO[Any, Nothing, WorkgroupName] =
      ZIO.succeed(workgroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.DeleteCustomDomainAssociationRequest
  ) extends zio.aws.redshiftserverless.model.DeleteCustomDomainAssociationRequest.ReadOnly {
    override val customDomainName: CustomDomainName =
      zio.aws.redshiftserverless.model.primitives
        .CustomDomainName(impl.customDomainName())
    override val workgroupName: WorkgroupName =
      zio.aws.redshiftserverless.model.primitives
        .WorkgroupName(impl.workgroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.DeleteCustomDomainAssociationRequest
  ): zio.aws.redshiftserverless.model.DeleteCustomDomainAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
