package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.redshiftserverless.model.primitives.{
  IamRoleArn,
  DbUser,
  NamespaceName,
  DbPassword,
  KmsKeyId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateNamespaceRequest(
    adminPasswordSecretKmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    adminUserPassword: Optional[DbPassword] = Optional.Absent,
    adminUsername: Optional[DbUser] = Optional.Absent,
    dbName: Optional[String] = Optional.Absent,
    defaultIamRoleArn: Optional[String] = Optional.Absent,
    iamRoles: Optional[Iterable[IamRoleArn]] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    logExports: Optional[Iterable[zio.aws.redshiftserverless.model.LogExport]] =
      Optional.Absent,
    manageAdminPassword: Optional[Boolean] = Optional.Absent,
    namespaceName: NamespaceName,
    tags: Optional[Iterable[zio.aws.redshiftserverless.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.CreateNamespaceRequest = {
    import CreateNamespaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.CreateNamespaceRequest
      .builder()
      .optionallyWith(
        adminPasswordSecretKmsKeyId.map(value =>
          KmsKeyId.unwrap(value): java.lang.String
        )
      )(_.adminPasswordSecretKmsKeyId)
      .optionallyWith(
        adminUserPassword.map(value =>
          DbPassword.unwrap(value): java.lang.String
        )
      )(_.adminUserPassword)
      .optionallyWith(
        adminUsername.map(value => DbUser.unwrap(value): java.lang.String)
      )(_.adminUsername)
      .optionallyWith(dbName.map(value => value: java.lang.String))(_.dbName)
      .optionallyWith(defaultIamRoleArn.map(value => value: java.lang.String))(
        _.defaultIamRoleArn
      )
      .optionallyWith(
        iamRoles.map(value =>
          value.map { item =>
            IamRoleArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.iamRoles)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        logExports.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.logExportsWithStrings)
      .optionallyWith(
        manageAdminPassword.map(value => value: java.lang.Boolean)
      )(_.manageAdminPassword)
      .namespaceName(NamespaceName.unwrap(namespaceName): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.CreateNamespaceRequest.ReadOnly =
    zio.aws.redshiftserverless.model.CreateNamespaceRequest
      .wrap(buildAwsValue())
}
object CreateNamespaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.CreateNamespaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.CreateNamespaceRequest =
      zio.aws.redshiftserverless.model.CreateNamespaceRequest(
        adminPasswordSecretKmsKeyId.map(value => value),
        adminUserPassword.map(value => value),
        adminUsername.map(value => value),
        dbName.map(value => value),
        defaultIamRoleArn.map(value => value),
        iamRoles.map(value => value),
        kmsKeyId.map(value => value),
        logExports.map(value => value),
        manageAdminPassword.map(value => value),
        namespaceName,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def adminPasswordSecretKmsKeyId: Optional[KmsKeyId]
    def adminUserPassword: Optional[DbPassword]
    def adminUsername: Optional[DbUser]
    def dbName: Optional[String]
    def defaultIamRoleArn: Optional[String]
    def iamRoles: Optional[List[IamRoleArn]]
    def kmsKeyId: Optional[String]
    def logExports: Optional[List[zio.aws.redshiftserverless.model.LogExport]]
    def manageAdminPassword: Optional[Boolean]
    def namespaceName: NamespaceName
    def tags: Optional[List[zio.aws.redshiftserverless.model.Tag.ReadOnly]]
    def getAdminPasswordSecretKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField(
        "adminPasswordSecretKmsKeyId",
        adminPasswordSecretKmsKeyId
      )
    def getAdminUserPassword: ZIO[Any, AwsError, DbPassword] =
      AwsError.unwrapOptionField("adminUserPassword", adminUserPassword)
    def getAdminUsername: ZIO[Any, AwsError, DbUser] =
      AwsError.unwrapOptionField("adminUsername", adminUsername)
    def getDbName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbName", dbName)
    def getDefaultIamRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultIamRoleArn", defaultIamRoleArn)
    def getIamRoles: ZIO[Any, AwsError, List[IamRoleArn]] =
      AwsError.unwrapOptionField("iamRoles", iamRoles)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getLogExports
        : ZIO[Any, AwsError, List[zio.aws.redshiftserverless.model.LogExport]] =
      AwsError.unwrapOptionField("logExports", logExports)
    def getManageAdminPassword: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("manageAdminPassword", manageAdminPassword)
    def getNamespaceName: ZIO[Any, Nothing, NamespaceName] =
      ZIO.succeed(namespaceName)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.redshiftserverless.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.CreateNamespaceRequest
  ) extends zio.aws.redshiftserverless.model.CreateNamespaceRequest.ReadOnly {
    override val adminPasswordSecretKmsKeyId: Optional[KmsKeyId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adminPasswordSecretKmsKeyId())
        .map(value =>
          zio.aws.redshiftserverless.model.primitives.KmsKeyId(value)
        )
    override val adminUserPassword: Optional[DbPassword] = zio.aws.core.internal
      .optionalFromNullable(impl.adminUserPassword())
      .map(value =>
        zio.aws.redshiftserverless.model.primitives.DbPassword(value)
      )
    override val adminUsername: Optional[DbUser] = zio.aws.core.internal
      .optionalFromNullable(impl.adminUsername())
      .map(value => zio.aws.redshiftserverless.model.primitives.DbUser(value))
    override val dbName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbName())
      .map(value => value: String)
    override val defaultIamRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultIamRoleArn())
      .map(value => value: String)
    override val iamRoles: Optional[List[IamRoleArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRoles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshiftserverless.model.primitives.IamRoleArn(item)
        }.toList
      )
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val logExports
        : Optional[List[zio.aws.redshiftserverless.model.LogExport]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logExports())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshiftserverless.model.LogExport.wrap(item)
          }.toList
        )
    override val manageAdminPassword: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.manageAdminPassword())
      .map(value => value: Boolean)
    override val namespaceName: NamespaceName =
      zio.aws.redshiftserverless.model.primitives
        .NamespaceName(impl.namespaceName())
    override val tags
        : Optional[List[zio.aws.redshiftserverless.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshiftserverless.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.CreateNamespaceRequest
  ): zio.aws.redshiftserverless.model.CreateNamespaceRequest.ReadOnly =
    new Wrapper(impl)
}
