package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.redshiftserverless.model.primitives.{
  WorkgroupName,
  CustomDomainName,
  CustomDomainCertificateArnString
}
import scala.jdk.CollectionConverters._
final case class CreateCustomDomainAssociationRequest(
    customDomainCertificateArn: CustomDomainCertificateArnString,
    customDomainName: CustomDomainName,
    workgroupName: WorkgroupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.CreateCustomDomainAssociationRequest = {
    import CreateCustomDomainAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.CreateCustomDomainAssociationRequest
      .builder()
      .customDomainCertificateArn(
        CustomDomainCertificateArnString.unwrap(
          customDomainCertificateArn
        ): java.lang.String
      )
      .customDomainName(
        CustomDomainName.unwrap(customDomainName): java.lang.String
      )
      .workgroupName(WorkgroupName.unwrap(workgroupName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.CreateCustomDomainAssociationRequest.ReadOnly =
    zio.aws.redshiftserverless.model.CreateCustomDomainAssociationRequest
      .wrap(buildAwsValue())
}
object CreateCustomDomainAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.CreateCustomDomainAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshiftserverless.model.CreateCustomDomainAssociationRequest =
      zio.aws.redshiftserverless.model.CreateCustomDomainAssociationRequest(
        customDomainCertificateArn,
        customDomainName,
        workgroupName
      )
    def customDomainCertificateArn: CustomDomainCertificateArnString
    def customDomainName: CustomDomainName
    def workgroupName: WorkgroupName
    def getCustomDomainCertificateArn
        : ZIO[Any, Nothing, CustomDomainCertificateArnString] =
      ZIO.succeed(customDomainCertificateArn)
    def getCustomDomainName: ZIO[Any, Nothing, CustomDomainName] =
      ZIO.succeed(customDomainName)
    def getWorkgroupName: ZIO[Any, Nothing, WorkgroupName] =
      ZIO.succeed(workgroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.CreateCustomDomainAssociationRequest
  ) extends zio.aws.redshiftserverless.model.CreateCustomDomainAssociationRequest.ReadOnly {
    override val customDomainCertificateArn: CustomDomainCertificateArnString =
      zio.aws.redshiftserverless.model.primitives
        .CustomDomainCertificateArnString(impl.customDomainCertificateArn())
    override val customDomainName: CustomDomainName =
      zio.aws.redshiftserverless.model.primitives
        .CustomDomainName(impl.customDomainName())
    override val workgroupName: WorkgroupName =
      zio.aws.redshiftserverless.model.primitives
        .WorkgroupName(impl.workgroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.CreateCustomDomainAssociationRequest
  ): zio.aws.redshiftserverless.model.CreateCustomDomainAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
