package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.redshiftserverless.model.primitives.{
  ParameterValue,
  ParameterKey
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConfigParameter(
    parameterKey: Optional[ParameterKey] = Optional.Absent,
    parameterValue: Optional[ParameterValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.ConfigParameter = {
    import ConfigParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.ConfigParameter
      .builder()
      .optionallyWith(
        parameterKey.map(value => ParameterKey.unwrap(value): java.lang.String)
      )(_.parameterKey)
      .optionallyWith(
        parameterValue.map(value =>
          ParameterValue.unwrap(value): java.lang.String
        )
      )(_.parameterValue)
      .build()
  }
  def asReadOnly: zio.aws.redshiftserverless.model.ConfigParameter.ReadOnly =
    zio.aws.redshiftserverless.model.ConfigParameter.wrap(buildAwsValue())
}
object ConfigParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.ConfigParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.ConfigParameter =
      zio.aws.redshiftserverless.model.ConfigParameter(
        parameterKey.map(value => value),
        parameterValue.map(value => value)
      )
    def parameterKey: Optional[ParameterKey]
    def parameterValue: Optional[ParameterValue]
    def getParameterKey: ZIO[Any, AwsError, ParameterKey] =
      AwsError.unwrapOptionField("parameterKey", parameterKey)
    def getParameterValue: ZIO[Any, AwsError, ParameterValue] =
      AwsError.unwrapOptionField("parameterValue", parameterValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ConfigParameter
  ) extends zio.aws.redshiftserverless.model.ConfigParameter.ReadOnly {
    override val parameterKey: Optional[ParameterKey] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterKey())
      .map(value =>
        zio.aws.redshiftserverless.model.primitives.ParameterKey(value)
      )
    override val parameterValue: Optional[ParameterValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameterValue())
        .map(value =>
          zio.aws.redshiftserverless.model.primitives.ParameterValue(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ConfigParameter
  ): zio.aws.redshiftserverless.model.ConfigParameter.ReadOnly = new Wrapper(
    impl
  )
}
