package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.redshiftserverless.model.primitives.{
  WorkgroupName,
  NamespaceName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RestoreFromSnapshotRequest(
    namespaceName: NamespaceName,
    ownerAccount: Optional[String] = Optional.Absent,
    snapshotArn: Optional[String] = Optional.Absent,
    snapshotName: Optional[String] = Optional.Absent,
    workgroupName: WorkgroupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.RestoreFromSnapshotRequest = {
    import RestoreFromSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.RestoreFromSnapshotRequest
      .builder()
      .namespaceName(NamespaceName.unwrap(namespaceName): java.lang.String)
      .optionallyWith(ownerAccount.map(value => value: java.lang.String))(
        _.ownerAccount
      )
      .optionallyWith(snapshotArn.map(value => value: java.lang.String))(
        _.snapshotArn
      )
      .optionallyWith(snapshotName.map(value => value: java.lang.String))(
        _.snapshotName
      )
      .workgroupName(WorkgroupName.unwrap(workgroupName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.RestoreFromSnapshotRequest.ReadOnly =
    zio.aws.redshiftserverless.model.RestoreFromSnapshotRequest
      .wrap(buildAwsValue())
}
object RestoreFromSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.RestoreFromSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshiftserverless.model.RestoreFromSnapshotRequest =
      zio.aws.redshiftserverless.model.RestoreFromSnapshotRequest(
        namespaceName,
        ownerAccount.map(value => value),
        snapshotArn.map(value => value),
        snapshotName.map(value => value),
        workgroupName
      )
    def namespaceName: NamespaceName
    def ownerAccount: Optional[String]
    def snapshotArn: Optional[String]
    def snapshotName: Optional[String]
    def workgroupName: WorkgroupName
    def getNamespaceName: ZIO[Any, Nothing, NamespaceName] =
      ZIO.succeed(namespaceName)
    def getOwnerAccount: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerAccount", ownerAccount)
    def getSnapshotArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotArn", snapshotArn)
    def getSnapshotName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotName", snapshotName)
    def getWorkgroupName: ZIO[Any, Nothing, WorkgroupName] =
      ZIO.succeed(workgroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.RestoreFromSnapshotRequest
  ) extends zio.aws.redshiftserverless.model.RestoreFromSnapshotRequest.ReadOnly {
    override val namespaceName: NamespaceName =
      zio.aws.redshiftserverless.model.primitives
        .NamespaceName(impl.namespaceName())
    override val ownerAccount: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerAccount())
      .map(value => value: String)
    override val snapshotArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotArn())
      .map(value => value: String)
    override val snapshotName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotName())
      .map(value => value: String)
    override val workgroupName: WorkgroupName =
      zio.aws.redshiftserverless.model.primitives
        .WorkgroupName(impl.workgroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.RestoreFromSnapshotRequest
  ): zio.aws.redshiftserverless.model.RestoreFromSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
