package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.redshiftserverless.model.primitives.{
  WorkgroupName,
  NamespaceName
}
import scala.jdk.CollectionConverters._
final case class RestoreFromRecoveryPointRequest(
    namespaceName: NamespaceName,
    recoveryPointId: String,
    workgroupName: WorkgroupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.RestoreFromRecoveryPointRequest = {
    import RestoreFromRecoveryPointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.RestoreFromRecoveryPointRequest
      .builder()
      .namespaceName(NamespaceName.unwrap(namespaceName): java.lang.String)
      .recoveryPointId(recoveryPointId: java.lang.String)
      .workgroupName(WorkgroupName.unwrap(workgroupName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.RestoreFromRecoveryPointRequest.ReadOnly =
    zio.aws.redshiftserverless.model.RestoreFromRecoveryPointRequest
      .wrap(buildAwsValue())
}
object RestoreFromRecoveryPointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.RestoreFromRecoveryPointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshiftserverless.model.RestoreFromRecoveryPointRequest =
      zio.aws.redshiftserverless.model.RestoreFromRecoveryPointRequest(
        namespaceName,
        recoveryPointId,
        workgroupName
      )
    def namespaceName: NamespaceName
    def recoveryPointId: String
    def workgroupName: WorkgroupName
    def getNamespaceName: ZIO[Any, Nothing, NamespaceName] =
      ZIO.succeed(namespaceName)
    def getRecoveryPointId: ZIO[Any, Nothing, String] =
      ZIO.succeed(recoveryPointId)
    def getWorkgroupName: ZIO[Any, Nothing, WorkgroupName] =
      ZIO.succeed(workgroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.RestoreFromRecoveryPointRequest
  ) extends zio.aws.redshiftserverless.model.RestoreFromRecoveryPointRequest.ReadOnly {
    override val namespaceName: NamespaceName =
      zio.aws.redshiftserverless.model.primitives
        .NamespaceName(impl.namespaceName())
    override val recoveryPointId: String = impl.recoveryPointId(): String
    override val workgroupName: WorkgroupName =
      zio.aws.redshiftserverless.model.primitives
        .WorkgroupName(impl.workgroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.RestoreFromRecoveryPointRequest
  ): zio.aws.redshiftserverless.model.RestoreFromRecoveryPointRequest.ReadOnly =
    new Wrapper(impl)
}
