package zio.aws.redshiftserverless.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.redshiftserverless.model.primitives.{
  NamespaceName,
  IamRoleArn,
  SyntheticTimestamp_date_time,
  DbUser
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Namespace(
    adminUsername: Optional[DbUser] = Optional.Absent,
    creationDate: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    dbName: Optional[String] = Optional.Absent,
    defaultIamRoleArn: Optional[String] = Optional.Absent,
    iamRoles: Optional[Iterable[IamRoleArn]] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    logExports: Optional[Iterable[zio.aws.redshiftserverless.model.LogExport]] =
      Optional.Absent,
    namespaceArn: Optional[String] = Optional.Absent,
    namespaceId: Optional[String] = Optional.Absent,
    namespaceName: Optional[NamespaceName] = Optional.Absent,
    status: Optional[zio.aws.redshiftserverless.model.NamespaceStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.Namespace = {
    import Namespace.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.Namespace
      .builder()
      .optionallyWith(
        adminUsername.map(value => DbUser.unwrap(value): java.lang.String)
      )(_.adminUsername)
      .optionallyWith(
        creationDate.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.creationDate)
      .optionallyWith(dbName.map(value => value: java.lang.String))(_.dbName)
      .optionallyWith(defaultIamRoleArn.map(value => value: java.lang.String))(
        _.defaultIamRoleArn
      )
      .optionallyWith(
        iamRoles.map(value =>
          value.map { item =>
            IamRoleArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.iamRoles)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        logExports.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.logExportsWithStrings)
      .optionallyWith(namespaceArn.map(value => value: java.lang.String))(
        _.namespaceArn
      )
      .optionallyWith(namespaceId.map(value => value: java.lang.String))(
        _.namespaceId
      )
      .optionallyWith(
        namespaceName.map(value =>
          NamespaceName.unwrap(value): java.lang.String
        )
      )(_.namespaceName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.redshiftserverless.model.Namespace.ReadOnly =
    zio.aws.redshiftserverless.model.Namespace.wrap(buildAwsValue())
}
object Namespace {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.Namespace
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.Namespace =
      zio.aws.redshiftserverless.model.Namespace(
        adminUsername.map(value => value),
        creationDate.map(value => value),
        dbName.map(value => value),
        defaultIamRoleArn.map(value => value),
        iamRoles.map(value => value),
        kmsKeyId.map(value => value),
        logExports.map(value => value),
        namespaceArn.map(value => value),
        namespaceId.map(value => value),
        namespaceName.map(value => value),
        status.map(value => value)
      )
    def adminUsername: Optional[DbUser]
    def creationDate: Optional[SyntheticTimestamp_date_time]
    def dbName: Optional[String]
    def defaultIamRoleArn: Optional[String]
    def iamRoles: Optional[List[IamRoleArn]]
    def kmsKeyId: Optional[String]
    def logExports: Optional[List[zio.aws.redshiftserverless.model.LogExport]]
    def namespaceArn: Optional[String]
    def namespaceId: Optional[String]
    def namespaceName: Optional[NamespaceName]
    def status: Optional[zio.aws.redshiftserverless.model.NamespaceStatus]
    def getAdminUsername: ZIO[Any, AwsError, DbUser] =
      AwsError.unwrapOptionField("adminUsername", adminUsername)
    def getCreationDate: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getDbName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbName", dbName)
    def getDefaultIamRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultIamRoleArn", defaultIamRoleArn)
    def getIamRoles: ZIO[Any, AwsError, List[IamRoleArn]] =
      AwsError.unwrapOptionField("iamRoles", iamRoles)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getLogExports
        : ZIO[Any, AwsError, List[zio.aws.redshiftserverless.model.LogExport]] =
      AwsError.unwrapOptionField("logExports", logExports)
    def getNamespaceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("namespaceArn", namespaceArn)
    def getNamespaceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("namespaceId", namespaceId)
    def getNamespaceName: ZIO[Any, AwsError, NamespaceName] =
      AwsError.unwrapOptionField("namespaceName", namespaceName)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.redshiftserverless.model.NamespaceStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.Namespace
  ) extends zio.aws.redshiftserverless.model.Namespace.ReadOnly {
    override val adminUsername: Optional[DbUser] = zio.aws.core.internal
      .optionalFromNullable(impl.adminUsername())
      .map(value => zio.aws.redshiftserverless.model.primitives.DbUser(value))
    override val creationDate: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationDate())
        .map(value =>
          zio.aws.redshiftserverless.model.primitives
            .SyntheticTimestamp_date_time(value)
        )
    override val dbName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbName())
      .map(value => value: String)
    override val defaultIamRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultIamRoleArn())
      .map(value => value: String)
    override val iamRoles: Optional[List[IamRoleArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRoles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshiftserverless.model.primitives.IamRoleArn(item)
        }.toList
      )
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val logExports
        : Optional[List[zio.aws.redshiftserverless.model.LogExport]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logExports())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshiftserverless.model.LogExport.wrap(item)
          }.toList
        )
    override val namespaceArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceArn())
      .map(value => value: String)
    override val namespaceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceId())
      .map(value => value: String)
    override val namespaceName: Optional[NamespaceName] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceName())
      .map(value =>
        zio.aws.redshiftserverless.model.primitives.NamespaceName(value)
      )
    override val status
        : Optional[zio.aws.redshiftserverless.model.NamespaceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.redshiftserverless.model.NamespaceStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.Namespace
  ): zio.aws.redshiftserverless.model.Namespace.ReadOnly = new Wrapper(impl)
}
