package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListWorkgroupsResponse(
    nextToken: Optional[String] = Optional.Absent,
    workgroups: Iterable[zio.aws.redshiftserverless.model.Workgroup]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsResponse = {
    import ListWorkgroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .workgroups(workgroups.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.ListWorkgroupsResponse.ReadOnly =
    zio.aws.redshiftserverless.model.ListWorkgroupsResponse
      .wrap(buildAwsValue())
}
object ListWorkgroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.ListWorkgroupsResponse =
      zio.aws.redshiftserverless.model.ListWorkgroupsResponse(
        nextToken.map(value => value),
        workgroups.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[String]
    def workgroups: List[zio.aws.redshiftserverless.model.Workgroup.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getWorkgroups: ZIO[Any, Nothing, List[
      zio.aws.redshiftserverless.model.Workgroup.ReadOnly
    ]] = ZIO.succeed(workgroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsResponse
  ) extends zio.aws.redshiftserverless.model.ListWorkgroupsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val workgroups
        : List[zio.aws.redshiftserverless.model.Workgroup.ReadOnly] = impl
      .workgroups()
      .asScala
      .map { item =>
        zio.aws.redshiftserverless.model.Workgroup.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListWorkgroupsResponse
  ): zio.aws.redshiftserverless.model.ListWorkgroupsResponse.ReadOnly =
    new Wrapper(impl)
}
