package zio.aws.redshiftserverless.model
import zio.prelude.data.Optional
import zio.aws.redshiftserverless.model.primitives.{
  PaginationToken,
  ListUsageLimitsRequestMaxResultsInteger
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListUsageLimitsRequest(
    maxResults: Optional[ListUsageLimitsRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    resourceArn: Optional[String] = Optional.Absent,
    usageType: Optional[zio.aws.redshiftserverless.model.UsageLimitUsageType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsRequest = {
    import ListUsageLimitsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListUsageLimitsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(resourceArn.map(value => value: java.lang.String))(
        _.resourceArn
      )
      .optionallyWith(usageType.map(value => value.unwrap))(_.usageType)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.ListUsageLimitsRequest.ReadOnly =
    zio.aws.redshiftserverless.model.ListUsageLimitsRequest
      .wrap(buildAwsValue())
}
object ListUsageLimitsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.ListUsageLimitsRequest =
      zio.aws.redshiftserverless.model.ListUsageLimitsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        resourceArn.map(value => value),
        usageType.map(value => value)
      )
    def maxResults: Optional[ListUsageLimitsRequestMaxResultsInteger]
    def nextToken: Optional[PaginationToken]
    def resourceArn: Optional[String]
    def usageType
        : Optional[zio.aws.redshiftserverless.model.UsageLimitUsageType]
    def getMaxResults
        : ZIO[Any, AwsError, ListUsageLimitsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResourceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getUsageType: ZIO[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.UsageLimitUsageType
    ] = AwsError.unwrapOptionField("usageType", usageType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsRequest
  ) extends zio.aws.redshiftserverless.model.ListUsageLimitsRequest.ReadOnly {
    override val maxResults: Optional[ListUsageLimitsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.redshiftserverless.model.primitives
            .ListUsageLimitsRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.redshiftserverless.model.primitives.PaginationToken(value)
      )
    override val resourceArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => value: String)
    override val usageType
        : Optional[zio.aws.redshiftserverless.model.UsageLimitUsageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usageType())
        .map(value =>
          zio.aws.redshiftserverless.model.UsageLimitUsageType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListUsageLimitsRequest
  ): zio.aws.redshiftserverless.model.ListUsageLimitsRequest.ReadOnly =
    new Wrapper(impl)
}
