package zio.aws.redshiftserverless.model
import zio.prelude.data.Optional
import zio.aws.redshiftserverless.model.primitives.{
  PaginationToken,
  ListTableRestoreStatusRequestMaxResultsInteger
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTableRestoreStatusRequest(
    maxResults: Optional[ListTableRestoreStatusRequestMaxResultsInteger] =
      Optional.Absent,
    namespaceName: Optional[String] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    workgroupName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusRequest = {
    import ListTableRestoreStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListTableRestoreStatusRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(namespaceName.map(value => value: java.lang.String))(
        _.namespaceName
      )
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(workgroupName.map(value => value: java.lang.String))(
        _.workgroupName
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.ListTableRestoreStatusRequest.ReadOnly =
    zio.aws.redshiftserverless.model.ListTableRestoreStatusRequest
      .wrap(buildAwsValue())
}
object ListTableRestoreStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshiftserverless.model.ListTableRestoreStatusRequest =
      zio.aws.redshiftserverless.model.ListTableRestoreStatusRequest(
        maxResults.map(value => value),
        namespaceName.map(value => value),
        nextToken.map(value => value),
        workgroupName.map(value => value)
      )
    def maxResults: Optional[ListTableRestoreStatusRequestMaxResultsInteger]
    def namespaceName: Optional[String]
    def nextToken: Optional[PaginationToken]
    def workgroupName: Optional[String]
    def getMaxResults
        : ZIO[Any, AwsError, ListTableRestoreStatusRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNamespaceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("namespaceName", namespaceName)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getWorkgroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("workgroupName", workgroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusRequest
  ) extends zio.aws.redshiftserverless.model.ListTableRestoreStatusRequest.ReadOnly {
    override val maxResults
        : Optional[ListTableRestoreStatusRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.redshiftserverless.model.primitives
            .ListTableRestoreStatusRequestMaxResultsInteger(value)
        )
    override val namespaceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.namespaceName())
      .map(value => value: String)
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.redshiftserverless.model.primitives.PaginationToken(value)
      )
    override val workgroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.workgroupName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListTableRestoreStatusRequest
  ): zio.aws.redshiftserverless.model.ListTableRestoreStatusRequest.ReadOnly =
    new Wrapper(impl)
}
