package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListEndpointAccessResponse(
    endpoints: Iterable[zio.aws.redshiftserverless.model.EndpointAccess],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessResponse = {
    import ListEndpointAccessResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessResponse
      .builder()
      .endpoints(endpoints.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.ListEndpointAccessResponse.ReadOnly =
    zio.aws.redshiftserverless.model.ListEndpointAccessResponse
      .wrap(buildAwsValue())
}
object ListEndpointAccessResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshiftserverless.model.ListEndpointAccessResponse =
      zio.aws.redshiftserverless.model.ListEndpointAccessResponse(
        endpoints.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def endpoints
        : List[zio.aws.redshiftserverless.model.EndpointAccess.ReadOnly]
    def nextToken: Optional[String]
    def getEndpoints: ZIO[Any, Nothing, List[
      zio.aws.redshiftserverless.model.EndpointAccess.ReadOnly
    ]] = ZIO.succeed(endpoints)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessResponse
  ) extends zio.aws.redshiftserverless.model.ListEndpointAccessResponse.ReadOnly {
    override val endpoints
        : List[zio.aws.redshiftserverless.model.EndpointAccess.ReadOnly] = impl
      .endpoints()
      .asScala
      .map { item =>
        zio.aws.redshiftserverless.model.EndpointAccess.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessResponse
  ): zio.aws.redshiftserverless.model.ListEndpointAccessResponse.ReadOnly =
    new Wrapper(impl)
}
