package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.redshiftserverless.model.primitives.WorkgroupName
import scala.jdk.CollectionConverters._
final case class GetWorkgroupRequest(workgroupName: WorkgroupName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.GetWorkgroupRequest = {
    import GetWorkgroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.GetWorkgroupRequest
      .builder()
      .workgroupName(WorkgroupName.unwrap(workgroupName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.GetWorkgroupRequest.ReadOnly =
    zio.aws.redshiftserverless.model.GetWorkgroupRequest.wrap(buildAwsValue())
}
object GetWorkgroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.GetWorkgroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.GetWorkgroupRequest =
      zio.aws.redshiftserverless.model.GetWorkgroupRequest(workgroupName)
    def workgroupName: WorkgroupName
    def getWorkgroupName: ZIO[Any, Nothing, WorkgroupName] =
      ZIO.succeed(workgroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.GetWorkgroupRequest
  ) extends zio.aws.redshiftserverless.model.GetWorkgroupRequest.ReadOnly {
    override val workgroupName: WorkgroupName =
      zio.aws.redshiftserverless.model.primitives
        .WorkgroupName(impl.workgroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.GetWorkgroupRequest
  ): zio.aws.redshiftserverless.model.GetWorkgroupRequest.ReadOnly =
    new Wrapper(impl)
}
