package zio.aws.redshiftserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetEndpointAccessResponse(
    endpoint: Optional[zio.aws.redshiftserverless.model.EndpointAccess] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshiftserverless.model.GetEndpointAccessResponse = {
    import GetEndpointAccessResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshiftserverless.model.GetEndpointAccessResponse
      .builder()
      .optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint)
      .build()
  }
  def asReadOnly
      : zio.aws.redshiftserverless.model.GetEndpointAccessResponse.ReadOnly =
    zio.aws.redshiftserverless.model.GetEndpointAccessResponse
      .wrap(buildAwsValue())
}
object GetEndpointAccessResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshiftserverless.model.GetEndpointAccessResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshiftserverless.model.GetEndpointAccessResponse =
      zio.aws.redshiftserverless.model
        .GetEndpointAccessResponse(endpoint.map(value => value.asEditable))
    def endpoint
        : Optional[zio.aws.redshiftserverless.model.EndpointAccess.ReadOnly]
    def getEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.redshiftserverless.model.EndpointAccess.ReadOnly
    ] = AwsError.unwrapOptionField("endpoint", endpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshiftserverless.model.GetEndpointAccessResponse
  ) extends zio.aws.redshiftserverless.model.GetEndpointAccessResponse.ReadOnly {
    override val endpoint
        : Optional[zio.aws.redshiftserverless.model.EndpointAccess.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpoint())
        .map(value =>
          zio.aws.redshiftserverless.model.EndpointAccess.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshiftserverless.model.GetEndpointAccessResponse
  ): zio.aws.redshiftserverless.model.GetEndpointAccessResponse.ReadOnly =
    new Wrapper(impl)
}
